

<?php $__env->startSection('content'); ?>
    <div class="container">
        <h3 class="mb-4 py-2">Daftar Mitra</h3>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($error); ?><br>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <div class="mb-2">
            <a href="<?php echo e(route('mitras.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Tambah Mitra
            </a>
        </div>

        <div class="card shadow-sm">
            <div class="card-body p-3 table-responsive">
                <table id="mitra-table" class="table table-striped table-hover align-middle mb-0">
                    <thead>
                        <tr>
                            <th style="width:5%;">No</th>
                            <th>Nama</th>
                            <th style="width:10%;">Gambar</th>
                            <th>Latitude</th>
                            <th>Longitude</th>
                            <th>Produk</th>
                            <th style="width:18%;" class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $mitras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mitra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($mitra->name); ?></td>
                                <td class="text-center">
                                    <?php
                                        $imagePath = $mitra->image
                                            ? 'storage/' . $mitra->image
                                            : 'storage/mitras/default_mitra.jpg';
                                    ?>
                                    <img src="<?php echo e(asset($imagePath)); ?>" alt="Foto Mitra" width="70"
                                        class="rounded shadow-sm">
                                </td>
                                <td><?php echo e($mitra->latitude); ?></td>
                                <td><?php echo e($mitra->longitude); ?></td>
                                <td>
                                    <?php $__currentLoopData = $mitra->produks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span><?php echo e($produk->name); ?></span> <br>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td class="text-center" style="white-space: nowrap;">
                                    <!-- Tombol buka modal -->
                                    

                                    <?php if(in_array(Auth::user()->akses, ['admin', 'sales'])): ?>
                                        <button type="button" class="btn btn-secondary btn-sm me-2" data-toggle="modal"
                                            data-target="#produkModal-<?php echo e($mitra->id); ?>">
                                            <i class="fas fa-cubes"></i> Atur Produk
                                        </button>
                                    <?php endif; ?>

                                    <a href="<?php echo e(route('mitras.show', $mitra->id)); ?>" class="btn btn-info btn-sm me-2">
                                        <i class="fas fa-eye"></i> Detail
                                    </a>

                                    <?php if(Auth::user()->akses == 'admin'): ?>
                                        <a href="<?php echo e(route('mitras.edit', $mitra->id)); ?>"
                                            class="btn btn-warning btn-sm me-2">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <form id="delete-form-<?php echo e($mitra->id); ?>"
                                            action="<?php echo e(route('mitras.destroy', $mitra->id)); ?>" method="POST"
                                            class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="button" class="btn btn-danger btn-sm"
                                                onclick="confirmDelete(<?php echo e($mitra->id); ?>)">
                                                <i class="fas fa-trash"></i> Hapus
                                            </button>
                                        </form>
                                    <?php endif; ?>


                                </td>


                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        
                        <?php if(in_array(Auth::user()->akses, ['admin', 'sales'])): ?>
                            <?php $__currentLoopData = $mitras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mitra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <!-- Modal Atur Produk -->
                                <div class="modal fade" id="produkModal-<?php echo e($mitra->id); ?>" tabindex="-1"
                                    aria-labelledby="produkModalLabel-<?php echo e($mitra->id); ?>" aria-hidden="true">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <form action="<?php echo e(route('mitras.setProduk', $mitra->id)); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="produkModalLabel-<?php echo e($mitra->id); ?>">Atur
                                                        Produk untuk: <?php echo e($mitra->name); ?></h5>
                                                    <!-- Tombol close modal -->
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="row">
                                                        <input type="hidden" name="mitra_id" value="<?php echo e($mitra->id); ?>">
                                                        <?php $__currentLoopData = $produks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="col-md-4 mb-2">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="checkbox"
                                                                        <?php echo e($mitra->produks->contains($produk->id) ? 'checked' : ''); ?>

                                                                        name="produk_ids[]" value="<?php echo e($produk->id); ?>">
                                                                    <label
                                                                        class="form-check-label"><?php echo e($produk->name); ?></label>
                                                                </div>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    
                                                    <button type="submit" class="btn btn-primary">Simpan</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>


                    </tbody>
                </table>
            </div>
        </div>
    </div> <!-- Penutup container -->

<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('#mitra-table').DataTable({
                responsive: true,
                autoWidth: false,
            });
        });

        function confirmDelete(id) {
            Swal.fire({
                title: 'Apakah kamu yakin?',
                text: "Data yang dihapus tidak bisa dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            })
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/mitras/index.blade.php ENDPATH**/ ?>