

<?php $__env->startPush('styles'); ?>
    <style>
        .fa-square {
            font-size: 1.2rem;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <h3 class="mb-4 py-2">Dashboard</h3>
        
        <?php if(auth()->user()->akses === 'admin'): ?>
            <div class="row">
                <div class="col-lg-4 col-6">
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3><?php echo e($totalProduk); ?></h3>
                            
                            <p>Total Produk</p>
                        </div>
                        <div class="icon"><i class="fas fa-boxes"></i></div>
                    </div>
                </div>
                <div class="col-lg-4 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3><?php echo e($totalMitra); ?></h3>
                            <p>Total Mitra</p>
                        </div>
                        <div class="icon"><i class="fas fa-users"></i></div>
                    </div>
                </div>
                <div class="col-lg-4 col-6">
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3><?php echo e($totalStokTersedia); ?></h3>
                            <p>Total Stok Tersedia</p>
                        </div>
                        <div class="icon"><i class="fas fa-warehouse"></i></div>
                    </div>
                </div>
            </div>

            
            <div class="card mt-4">
                <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
                    <h3 class="card-title mb-0">Grafik Penjualan Bulanan</h3>

                    <div class="ms-auto">
                        <form method="GET" class="d-flex align-items-center">
                            <label for="tahun" class="me-2 mb-0">Pilih Tahun:</label>
                            <select name="tahun" id="tahun" class="form-control" onchange="this.form.submit()">
                                <option value="">Semua Tahun</option>
                                <?php $__currentLoopData = $daftarTahun; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tahun): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tahun); ?>" <?php echo e($tahun == $tahunDipilih ? 'selected' : ''); ?>>
                                        <?php echo e($tahun); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </form>
                    </div>
                </div>

                <div class="card-body">
                    <canvas id="penjualanChart" height="175"></canvas>
                    <div class="mt-3 d-flex flex-wrap align-items-center">
                        <span class="me-3"><i class="fas fa-square text-danger me-1"></i> Rendah</span>
                        <span class="me-3"><i class="fas fa-square text-warning me-1"></i> Sedang</span>
                        <span class="me-3"><i class="fas fa-square text-primary me-1"></i> Tinggi</span>
                    </div>
                </div>
            </div>

            
            <div class="card mt-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">📋 Laporan Penjualan & Retur (Admin)</h5>
                </div>
                <div class="card-body table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Nama Mitra</th>
                                <th>Nama Produk</th>
                                <th>Sisa Stok</th>
                                <th>Jumlah Terjual</th>
                                <th>Jumlah Retur</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $stokPerProdukMitra; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($item['mitra_nama']); ?></td>
                                    <td><?php echo e($item['produk_nama']); ?></td>
                                    <td><?php echo e($item['sisa']); ?></td>
                                    <td><?php echo e($item['terjual']); ?></td>
                                    <td><?php echo e($item['retur']); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center">Tidak ada data stok tersedia.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>


            
        <?php elseif(auth()->user()->akses === 'sales'): ?>
            
            <div class="row mb-4">
                <div class="col-md-4 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3><?php echo e($totalProdukSales); ?></h3>
                            <p>Total Produk</p>
                        </div>
                        <div class="icon"><i class="fas fa-cubes"></i></div>
                    </div>
                </div>

                <div class="col-md-4 col-6">
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h3><?php echo e($totalReturSales); ?></h3>
                            <p>Total Retur</p>
                        </div>
                        <div class="icon"><i class="fas fa-undo-alt"></i></div>
                    </div>
                </div>

                <div class="col-md-4 col-6">
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3><?php echo e($terjualSales); ?></h3>
                            <p>Total Penjualan</p>
                        </div>
                        <div class="icon"><i class="fas fa-chart-line"></i></div>
                    </div>
                </div>
            </div>

            
            <div class="card mt-4">
                <div class="card-header">
                    <h3 class="card-title">Grafik Produk Terjual per Mitra</h3>
                </div>
                <div class="card-body">
                    <canvas id="grafikProdukPerMitra" height="175"></canvas>
                </div>
            </div>


            
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title">📊 Laporan Penjualan & Retur</h5>
                </div>
                <div class="card-body table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Nama Mitra</th>
                                <th>Nama Produk</th>
                                <th>Sisa Stok</th>
                                <th>Jumlah Terjual</th>
                                <th>Jumlah Retur</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $tabelPenjualanSales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($item['mitra']); ?></td>
                                    <td><?php echo e($item['produk']); ?></td>
                                    <td><?php echo e($item['sisa']); ?></td>
                                    <td><?php echo e($item['terjual']); ?></td>
                                    <td><?php echo e($item['retur']); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center">Tidak ada data penjualan.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <?php if(auth()->user()->akses === 'admin'): ?>
        <script>
            const dataTerjual = <?php echo json_encode($dataTerjual); ?>;
            const max = Math.max(...dataTerjual);
            const min = Math.min(...dataTerjual);

            function getColor(value) {
                if (max === min) return 'rgba(100, 149, 237, 0.6)';
                const ratio = (value - min) / (max - min);
                if (ratio < 0.33) return 'rgba(255, 99, 132, 0.7)';
                if (ratio < 0.66) return 'rgba(255, 206, 86, 0.7)';
                return 'rgba(75, 192, 192, 0.7)';
            }

            const backgroundColors = dataTerjual.map(getColor);

            const ctx = document.getElementById('penjualanChart').getContext('2d');
            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode($labelBulan); ?>,
                    datasets: [{
                        label: 'Jumlah Terjual',
                        data: dataTerjual,
                        backgroundColor: backgroundColors,
                        borderColor: backgroundColors,
                        borderWidth: 1,
                        borderRadius: 5
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            display: false
                        },
                        title: {
                            display: true,
                            text: <?php echo json_encode('Penjualan per Bulan' . ($tahunDipilih ? " ($tahunDipilih)" : ' (Semua Tahun)')); ?>

                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0
                            }
                        }
                    }
                }
            });
        </script>
    <?php endif; ?>

    <?php if(auth()->user()->akses === 'sales'): ?>
        <script>
            const dataGrafik = <?php echo json_encode($grafikTerjualSales); ?>;

            const mitraLabels = dataGrafik.map(item => item.mitra);
            const produkLabels = dataGrafik.map(item => item.produk);
            const values = dataGrafik.map(item => item.terjual);

            const maxVal = Math.max(...values);
            const minVal = Math.min(...values);

            const warnaBatang = values.map(val => {
                if (maxVal === minVal) return 'rgba(54, 162, 235, 0.7)';
                const ratio = (val - minVal) / (maxVal - minVal);
                if (ratio < 0.33) return 'rgba(255, 99, 132, 0.7)';
                if (ratio < 0.66) return 'rgba(255, 206, 86, 0.7)';
                return 'rgba(75, 192, 192, 0.7)';
            });

            const ctxProdukMitra = document.getElementById('grafikProdukPerMitra').getContext('2d');
            new Chart(ctxProdukMitra, {
                type: 'bar',
                data: {
                    labels: produkLabels, // disembunyikan nanti
                    datasets: [{
                        data: values,
                        backgroundColor: warnaBatang,
                        borderColor: warnaBatang,
                        borderWidth: 1,
                        borderRadius: 5,
                        borderSkipped: false
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            display: false
                        },
                        title: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    const index = context.dataIndex;
                                    return [
                                        'Toko: ' + mitraLabels[index],
                                        'Produk: ' + produkLabels[index],
                                        'Terjual: ' + values[index]
                                    ];
                                }
                            }
                        }
                    },
                    scales: {
                        x: {
                            ticks: {
                                display: false
                            },
                            grid: {
                                display: false
                            }
                        },
                        y: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0
                            },
                            grid: {
                                color: '#eee'
                            }
                        }
                    }
                }
            });
        </script>
    <?php endif; ?>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/dashboard/index.blade.php ENDPATH**/ ?>