

<?php $__env->startSection('content'); ?>
    <div class="container">
        <h3 class="mb-4 py-2">Edit Data Pengiriman Stok</h3>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($error); ?><br>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>
        <div class="card shadow-sm">
            <div class="card-body">
                <form action="<?php echo e(route('pengiriman.update', $pengiriman->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="produk_id" class="form-label">Produk</label>
                            <select class="form-control" id="produk_id" name="produk_id" required>
                                <option value="" disabled>-- Pilih Produk --</option>
                                <?php $__currentLoopData = $produks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($produk->id); ?>"
                                        <?php echo e(old('produk_id', $pengiriman->produk_id) == $produk->id ? 'selected' : ''); ?>>
                                        <?php echo e($produk->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="mitra_id" class="form-label">Mitra</label>
                            <select class="form-control" id="mitra_id" name="mitra_id" required>
                                <option value="" disabled>-- Pilih Mitra --</option>
                                <?php $__currentLoopData = $mitras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mitra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($mitra->id); ?>"
                                        <?php echo e(old('mitra_id', $pengiriman->mitra_id) == $mitra->id ? 'selected' : ''); ?>>
                                        <?php echo e($mitra->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Total Sisa Sebelumnya</label>
                            <input type="number" class="form-control bg-light" id="total_sisa_all_display" readonly
                                value="<?php echo e($sisa); ?>" data-sisa-awal="<?php echo e($sisa); ?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="masuk" class="form-label">Jumlah Masuk</label>
                            <input type="number" min="0" class="form-control" id="masuk" name="masuk"
                                value="<?php echo e(old('masuk', $pengiriman->masuk)); ?>" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="terjual" class="form-label">Jumlah Terjual</label>
                            <input type="number" min="0" class="form-control" id="terjual" name="terjual"
                                value="<?php echo e(old('terjual', $pengiriman->terjual)); ?>">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="date" class="form-label">Tanggal</label>
                            <input type="date" class="form-control" id="date" name="date"
                                value="<?php echo e(old('date', $pengiriman->date)); ?>" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="return" class="form-label">Return</label>
                            <input type="number" min="0" class="form-control" id="return" name="return"
                                value="<?php echo e(old('return', $pengiriman->return)); ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="sisa" class="form-label">Sisa </label>
                            <input type="text" class="form-control" id="sisa" name="sisa"
                                value="<?php echo e(old('sisa', $pengiriman->sisa)); ?>" readonly>
                        </div>
                        <?php if(Auth::user()->akses === 'sales'): ?>
                            <input type="hidden" name="sales_id" value="<?php echo e(Auth::id()); ?>">
                        <?php else: ?>
                            <div class="col-md-4 mb-3">
                                <label for="sales_id" class="form-label">Penanggung Jawab</label>
                                <select name="sales_id" id="sales_id" class="form-control" required>
                                    <option value="">Pilih Penanggung Jawab</option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($user->id); ?>"
                                            <?php echo e((int) old('sales_id', $pengiriman->sales_id ?? null) === $user->id ? 'selected' : ''); ?>>
                                            <?php echo e($user->username); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        <?php endif; ?>


                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i> Update
                    </button>
                    <a href="<?php echo e(route('pengiriman.index')); ?>" class="btn btn-secondary ms-2">
                        <i class="fas fa-arrow-left me-1"></i> Kembali
                    </a>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        let lastValidSisa = 0; // simpan nilai sisa terakhir yang valid

        function hitungSisa() {
            const totalSisaAwal = parseInt(document.getElementById('total_sisa_all_display').getAttribute(
                'data-sisa-awal')) || 0;
            const masuk = parseInt(document.getElementById('masuk').value) || 0;
            const terjual = parseInt(document.getElementById('terjual').value) || 0;
            const retur = parseInt(document.getElementById('return').value) || 0;

            // Hitung sisa
            const sisaMitra = totalSisaAwal + masuk - terjual - retur;

            if (sisaMitra < 0) {
                alert('Perhitungan stok menghasilkan nilai negatif! Periksa jumlah masuk, terjual, dan return.');
                // Kembalikan ke nilai sebelumnya
                document.getElementById('sisa').value = lastValidSisa;
                return;
            }

            // Update input dan simpan nilai terakhir yang valid
            document.getElementById('sisa').value = sisaMitra;
            lastValidSisa = sisaMitra;
        }

        ['masuk', 'terjual', 'return'].forEach(id => {
            document.getElementById(id).addEventListener('input', hitungSisa);
        });

        window.addEventListener('DOMContentLoaded', () => {
            // Hitung pertama kali dan set nilai awal yang valid
            hitungSisa();
            lastValidSisa = parseInt(document.getElementById('sisa').value) || 0;
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/laporan/edit.blade.php ENDPATH**/ ?>