

<?php $__env->startSection('content'); ?>
    <div class="container">
        <h3 class="mb-4 py-2">Tambah Data Pengiriman Stok</h3>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo implode('<br>', $errors->all()); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <div class="card shadow-sm">
            <div class="card-body">
                <form action="<?php echo e(route('pengiriman.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="produk_id" class="form-label">Produk</label>
                            <select class="form-control" id="produk_id" name="produk_id" required>
                                <option value="<?php echo e($produk->id); ?>"><?php echo e($produk->name); ?></option>
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="mitra_id" class="form-label">Mitra</label>
                            <select class="form-control" id="mitra_id" name="mitra_id" required>
                                <option value="<?php echo e($mitra->id); ?>"><?php echo e($mitra->name); ?></option>
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label class="form-label">Total Sisa Stok</label>
                            <input type="number" class="form-control bg-light" id="total_sisa_all_display" readonly
                                value="<?php echo e($sisa); ?>"
                                data-sisa-awal="<?php echo e($sisa); ?>">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="masuk" class="form-label">Jumlah Masuk</label>
                            <input type="number" min="0" class="form-control" id="masuk" name="masuk"
                                value="<?php echo e(old('masuk', 0)); ?>" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="terjual" class="form-label">Jumlah Terjual</label>
                            <input type="number" min="0" class="form-control" id="terjual" name="terjual"
                                value="<?php echo e(old('terjual', 0)); ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="date" class="form-label">Tanggal</label>
                            <input type="date" class="form-control" id="date" name="date"
                                value="<?php echo e(old('date', now()->format('Y-m-d'))); ?>" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="return" class="form-label">Return</label>
                            <input type="number" min="0" class="form-control" id="return" name="return"
                                value="<?php echo e(old('return', 0)); ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="sisa" class="form-label">Sisa</label>
                            <input type="text" class="form-control" id="sisa" name="sisa"
                                value="<?php echo e(old('sisa', 0)); ?>" readonly>
                        </div>

                        <?php if(Auth::user()->akses === 'sales'): ?>
                            <input type="hidden" name="sales_id" value="<?php echo e(Auth::id()); ?>">
                        <?php else: ?>
                            <div class="col-md-4 mb-3">
                                <label for="sales_id" class="form-label">Penanggung Jawab</label>
                                <select name="sales_id" id="sales_id" class="form-control" required>
                                    <option value="">Pilih Penanggung Jawab</option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($user->id); ?>"
                                            <?php echo e(old('sales_id', $userTerpilih->id ?? '') == $user->id ? 'selected' : ''); ?>>
                                            <?php echo e($user->username); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="mt-3">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-1"></i> Simpan
                        </button>
                        <a href="<?php echo e(route('pengiriman.index')); ?>" class="btn btn-secondary ms-2">
                            <i class="fas fa-arrow-left me-1"></i> Kembali
                        </a>
                    </div>
                    
                    
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        let lastValidSisa = 0; // simpan nilai sisa terakhir yang valid

        function hitungSisa() {
            const totalSisaAwal = parseInt(document.getElementById('total_sisa_all_display').getAttribute('data-sisa-awal')) || 0;
            const masuk = parseInt(document.getElementById('masuk').value) || 0;
            const terjual = parseInt(document.getElementById('terjual').value) || 0;
            const retur = parseInt(document.getElementById('return').value) || 0;

            // Hitung sisa
            const sisaMitra = totalSisaAwal + masuk - terjual - retur;

            if (sisaMitra < 0) {
                alert('Perhitungan stok menghasilkan nilai negatif! Periksa jumlah masuk, terjual, dan return.');
                // Kembalikan ke nilai sebelumnya
                document.getElementById('sisa').value = lastValidSisa;
                return;
            }

            // Update input dan simpan nilai terakhir yang valid
            document.getElementById('sisa').value = sisaMitra;
            lastValidSisa = sisaMitra;
        }

        ['masuk', 'terjual', 'return'].forEach(id => {
            document.getElementById(id).addEventListener('input', hitungSisa);
        });

        window.addEventListener('DOMContentLoaded', () => {
            // Hitung pertama kali dan set nilai awal yang valid
            hitungSisa();
            lastValidSisa = parseInt(document.getElementById('sisa').value) || 0;
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/laporan/create.blade.php ENDPATH**/ ?>