

<?php $__env->startSection('content'); ?>
    <div class="container">
        <h3 class="mb-4 py-2 ">Daftar Stok Mitra</h3>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($error); ?><br>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        


        <div class="card shadow-sm">
            <div class="card-body p-3 table-responsive">
                <table id="stok-table" class="table table-striped table-hover align-middle mb-0 nowrap w-100">
                    <thead>
                        <tr>
                            <th style="width:5%;">No</th>
                            <th>Tanggal</th>
                            <th>Produk</th>
                            <th>Mitra</th>
                            <th class="text-center">Masuk</th>
                            <th class="text-center">Terjual</th>
                            <th class="text-center">Return</th>
                            <th class="text-center">Sisa</th>
                            
                            
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $stoks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stok): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($stok->date)->format('d/m/Y')); ?></td>
                                <td><?php echo e($stok->produk->name); ?></td>
                                <td><?php echo e($stok->mitra->name); ?></td>
                                <td class="text-center"><?php echo e($stok->masuk); ?></td>
                                <td class="text-center"><?php echo e($stok->terjual); ?></td>
                                <td class="text-center"><?php echo e($stok->return); ?></td>
                                <td class="text-center"><?php echo e($stok->sisa); ?></td>
                                
                                
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('#stok-table').DataTable({
                responsive: true,
                autoWidth: false,
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.11.5/i18n/Indonesian.json'
                }
            });
        });

        function confirmDelete(id) {
            Swal.fire({
                title: 'Apakah kamu yakin?',
                text: "Data yang dihapus tidak bisa dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/stoks/index.blade.php ENDPATH**/ ?>