

<?php $__env->startSection('content'); ?>
    <div class="container">
        <h3 class="mb-4 py-2">Laporan Pengiriman Stok</h3>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($error); ?><br>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        
        
        <?php if(Auth::user()->akses == 'admin'): ?>
            <a href="<?php echo e(route('pengiriman.export')); ?>" class="btn btn-success mb-2">
                <i class="fas fa-file-excel me-1"></i> Export Excel
            </a>
        <?php endif; ?>


        <div class="card shadow-sm">
            <div class="card-body p-3 table-responsive">
                <table id="pengiriman" class="table table-striped table-hover align-middle mb-0">
                    <thead>
                        <tr>
                            <th style="width:5%;">No</th>
                            <th>Tanggal</th>
                            <th>Produk</th>
                            <th>Mitra</th>
                            <th>Masuk</th>
                            <th>Terjual</th>
                            <th>Return</th>
                            <th>Sisa</th>
                            <th>Harga Satuan</th>
                            <th>Total Harga</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $totalKeseluruhan = 0; ?>

                        <?php $__currentLoopData = $stoks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($item->date)->format('d/m/Y')); ?></td>
                                <td><?php echo e($item->produk->name); ?></td>
                                <td><?php echo e($item->mitra->name); ?></td>
                                <td><?php echo e($item->masuk); ?></td>
                                <td><?php echo e($item->terjual); ?></td>
                                <td><?php echo e($item->return); ?></td>
                                <td><?php echo e($item->sisa); ?></td>
                                <td>Rp<?php echo e(number_format($item->produk->price, 0, ',', '.')); ?></td>
                                <td>Rp<?php echo e(number_format($item->terjual * $item->produk->price, 0, ',', '.')); ?></td>
                                <td>
                                    <?php if(Auth::user()->akses == 'admin'): ?>
                                        <a href="<?php echo e(route('pengiriman.edit', $item->id)); ?>"
                                            class="btn btn-warning btn-sm me-2 mb-1">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <form id="delete-form-<?php echo e($item->id); ?>"
                                            action="<?php echo e(route('pengiriman.destroy', $item->id)); ?>" method="POST"
                                            class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="button" class="btn btn-danger btn-sm"
                                                onclick="confirmDelete(<?php echo e($item->id); ?>)">
                                                <i class="fas fa-trash"></i> Hapus
                                            </button>
                                        </form>
                                    <?php else: ?>
                                        <a href="<?php echo e(route('mitras.show', $item->mitra->id)); ?>"
                                            class="btn btn-info btn-sm me-2">
                                            <i class="fas fa-eye"></i> Detaile
                                        </a>
                                    <?php endif; ?>

                                </td>
                            </tr>
                            <?php
                                $total = $item->terjual * $item->produk->price;
                                $totalKeseluruhan = $totalKeseluruhan + $total;
                            ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="8" class="text-end"><strong>Total Keseluruhan</strong></td>
                            <td></td>
                            <td><strong>Rp<?php echo e(number_format($totalKeseluruhan, 0, ',', '.')); ?></strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('#pengiriman').DataTable({
                responsive: true,
                autoWidth: false,
                order: [
                    [0, 'asc']
                ],
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.11.5/i18n/Indonesian.json'
                }
            });
        });

        function confirmDelete(id) {
            Swal.fire({
                title: 'Apakah kamu yakin?',
                text: "Data yang dihapus tidak bisa dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            })
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/laporan/index.blade.php ENDPATH**/ ?>