

<?php $__env->startSection('content'); ?>
    <div class="container">
      
        <h3 class="mb-4 py-2">Detail Mitra</h3>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($error); ?><br>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <div class="card shadow-sm">
            <div class="card-body">

                
                <div class="row justify-content-center mb-4">
                    <?php
                        $imagePath = $mitra->image ? 'storage/' . $mitra->image : 'storage/mitras/default_mitra.jpg';
                    ?>
                    <div class="col-12 col-sm-8 col-md-6 col-lg-4 text-center">
                        <img src="<?php echo e(asset($imagePath)); ?>" alt="Foto Mitra" class="img-fluid rounded shadow-sm"
                            style="max-height: 300px; width: auto;">
                    </div>
                </div>

                
                <div class="table-responsive mb-4">
                    <table class="table table-striped table-hover table-bordered">
                        <tbody>
                            <tr>
                                <th scope="row" style="width: 30%;">Nama</th>
                                <td><?php echo e($mitra->name); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Latitude</th>
                                <td><?php echo e($mitra->latitude); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Longitude</th>
                                <td><?php echo e($mitra->longitude); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                
                <h5 class="mb-3">Data Produk & Stok Mitra</h5>
                
                
                <?php $__currentLoopData = $mitra->produks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $produk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="mb-3">
                        <button class="btn btn-outline-primary btn-sm mb-2" type="button" data-toggle="collapse"
                            data-target="#stokCollapse<?php echo e($index); ?>" aria-expanded="false"
                            aria-controls="stokCollapse<?php echo e($index); ?>">
                            <i class="fas fa-box-open"></i> Lihat Data <?php echo e($produk->name); ?>

                        </button>
                        <?php if(Auth::user()->akses== 'sales'): ?>
                        <a href="/pengiriman/create?idproduk=<?php echo e($produk->id); ?>&mitra_id=<?php echo e($mitra->id); ?>&sales_id=<?php echo e(Auth::user()->id ?? ''); ?>"
                             class="btn btn-success btn-sm mb-2">
                             <i class="fas fa-plus"></i> Tambah Data
                         </a>
                        <?php endif; ?>

                        <div class="collapse" id="stokCollapse<?php echo e($index); ?>">
                            <div class="card card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Tanggal</th>
                                                <th>Stok</th>
                                                <th>Terjual</th>
                                                <th>Return</th>
                                                <th>Sisa</th>
                                                <th>Pengirim</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $adaData = false;
                                        ?>
                                        
                                        <?php $__empty_1 = true; $__currentLoopData = $produk->stoks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <?php if($item->produk_id == $produk->id && $item->mitra_id == $mitra->id): ?>
                                                <?php $adaData = true; ?>
                                                <tr>
                                                    <td><?php echo e(\Carbon\Carbon::parse($item->date)->format('d/m/Y')); ?></td>
                                                    <td><?php echo e($item->masuk); ?></td>
                                                    <td><?php echo e($item->terjual); ?></td>
                                                    <td><?php echo e($item->return); ?></td>
                                                    <td><?php echo e($item->sisa); ?></td>
                                                    <td><?php echo e($item->sales->username); ?></td>
                                                </tr>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="5" class="text-center text-muted">Tidak ada data stok.</td>
                                            </tr>
                                        <?php endif; ?>
                                        
                                        <?php if(!$adaData): ?>
                                            <tr>
                                                <td colspan="5" class="text-center text-muted">Tidak ada data stok.</td>
                                            </tr>
                                        <?php endif; ?>
                                        
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <a href="<?php echo e(route('mitras.index')); ?>" class="btn btn-secondary mt-4">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/mitras/show.blade.php ENDPATH**/ ?>