

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        
        <div class="row mb-3">
            <div class="col-12">
                <h3 class="mt-3">Daftar Produk</h3>
            </div>
        </div>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($error); ?><br>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        
        <div class="row mb-4 align-items-end">
            <div class="col-md-6 text-md-end mb-2">
                <a href="<?php echo e(route('produks.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Tambah Produk
                </a>
            </div>
            <div class="col-md-6 mb-2">
                <form method="GET" action="<?php echo e(route('produks.index')); ?>">
                    <div class="input-group">
                        <input type="text" name="search" class="form-control" placeholder="Cari produk..."
                            value="<?php echo e(request('search')); ?>">
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-search"></i>
                        </button>
                        <?php if(request('search')): ?>
                            <a href="<?php echo e(route('produks.index')); ?>" class="btn btn-outline-danger" title="Reset pencarian">
                                <i class="fas fa-times"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>


        
        <?php if($produks->count()): ?>
            <div class="row">
                <?php $__currentLoopData = $produks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-12 col-md-6 col-lg-4 mb-4">
                        <div class="card h-100 shadow-sm">
                            <?php if($produk->image): ?>
                                <img src="<?php echo e(asset('storage/' . $produk->image)); ?>" class="card-img-top"
                                    style="height: 200px; object-fit: cover;" alt="<?php echo e($produk->name); ?>">
                            <?php else: ?>
                                <div class="bg-light d-flex align-items-center justify-content-center"
                                    style="height: 200px;">
                                    <span class="text-muted">Tidak ada gambar</span>
                                </div>
                            <?php endif; ?>
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title"><?php echo e($produk->name); ?></h5>
                                <p class="card-text text-muted"><?php echo e(Str::limit($produk->explanation, 100)); ?></p>
                                <h5 class="card-title"><?php echo e($produk->price); ?></h5>
                            </div>
                            <div class="card-footer bg-white border-top-0 text-end">
                                <a href="<?php echo e(route('produks.show', $produk->id)); ?>" class="btn btn-sm btn-info me-1 mb-1">
                                    <i class="fas fa-eye"></i> Detail
                                </a>
                                <a href="<?php echo e(route('produks.edit', $produk->id)); ?>"
                                    class="btn btn-sm btn-warning me-1 mb-1">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                                <form id="delete-form-<?php echo e($produk->id); ?>"
                                    action="<?php echo e(route('produks.destroy', $produk->id)); ?>" method="POST"
                                    style="display: inline;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="button" class="btn btn-sm btn-danger mb-1"
                                        onclick="confirmDelete(<?php echo e($produk->id); ?>)">
                                        <i class="fas fa-trash"></i> Hapus
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="alert alert-info col-md-6">
                Belum ada produk yang tersedia. Klik <strong><a href="<?php echo e(route('produks.create')); ?>"
                        class="text-decoration-none text-warning">Tambah Produk</a></strong> untuk mulai menambahkan.
            </div>
        <?php endif; ?>

        
        <div class="d-flex justify-content-end mt-4">
            <?php echo e($produks->withQueryString()->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Apakah kamu yakin?',
                text: "Data yang dihapus tidak bisa dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            })
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/produks/index.blade.php ENDPATH**/ ?>