<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\StokController;
use App\Http\Controllers\UserController;
//use App\Http\Controllers\AdminController;
use App\Http\Controllers\MitraController;
use App\Http\Controllers\SalesController;
use App\Http\Controllers\ProdukController;
use App\Http\Controllers\LaporanController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\AnalitikController;
use App\Http\Controllers\KeuanganController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SalesStokController;
use App\Http\Controllers\StokMitraController;
use App\Http\Controllers\PengirimanStokController;
use App\Models\Produk;

// ===== Dashboard =====
Route::get('/', [DashboardController::class, 'index'])->middleware(['auth'])->name('dashboard.index');

// ===== Admin Routes =====
Route::middleware(['auth'])->group(function () {
    Route::resource('produks', ProdukController::class);
    Route::resource('stoks', StokController::class);
    Route::resource('mitras', MitraController::class);
//set produk
Route::post('/setProduk', [ProdukController::class, 'setProduk'])->name('mitras.setProduk');
    // User management
    Route::get('/users', [UserController::class, 'index'])->name('users.index');
    Route::get('/users/create', [UserController::class, 'create'])->name('users.create');
    Route::post('/users', [UserController::class, 'store'])->name('users.store');
    Route::get('/users/{id}/edit', [UserController::class, 'edit'])->name('users.edit');
    Route::put('/users/{id}', [UserController::class, 'update'])->name('users.update');
    Route::delete('/users/{id}', [UserController::class, 'destroy'])->name('users.destroy');

    // Analitik
    Route::get('/analitik', [AnalitikController::class, 'index'])->name('admin.analitik');
});

// ===== Authenticated Routes (Semua User Login) =====
Route::middleware(['auth'])->group(function () {
    Route::get('/pengiriman', [LaporanController::class, 'index'])->name('pengiriman.index');
    Route::get('/pengiriman/create', [LaporanController::class, 'create'])->name('pengiriman.create');
    Route::post('/pengiriman', [LaporanController::class, 'store'])->name('pengiriman.store');
    Route::get('/pengiriman/{id}/edit', [LaporanController::class, 'edit'])->name('pengiriman.edit');
    Route::put('/pengiriman/{id}', [LaporanController::class, 'update'])->name('pengiriman.update');
    Route::delete('/pengiriman/{id}', [LaporanController::class, 'destroy'])->name('pengiriman.destroy');
    Route::get('/pengiriman/export', [LaporanController::class, 'export'])->name('pengiriman.export');

    Route::get('/mitra-sales', [MitraController::class, 'salesMitra'])->name('mitra.sales');
  

    // Profil
    Route::get('/profile', [ProfileController::class, 'index'])->name('profile.index');
    Route::get('/profile/edit', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::post('/profile/update', [ProfileController::class, 'update'])->name('profile.update');
    Route::get('/profile/password', [ProfileController::class, 'changePassword'])->name('profile.password');
    Route::post('/profile/password', [ProfileController::class, 'updatePassword'])->name('profile.password.update');
    Route::delete('/profile/delete', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// ===== Auth (Login, Register, Lupa Password) =====
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::get('/register', [AuthController::class, 'showRegisterForm'])->name('register');
Route::post('/register', [AuthController::class, 'register']);

Route::get('/forgot-password', [AuthController::class, 'showForgotForm'])->name('password.request');
Route::post('/forgot-password', [AuthController::class, 'sendResetLink'])->name('password.email');
Route::get('/reset-password/{token}', [AuthController::class, 'showResetForm'])->name('password.reset');
Route::post('/reset-password', [AuthController::class, 'resetPassword'])->name('password.update');

Route::get('/verify-email/{token}', [AuthController::class, 'verifyEmail'])->name('verify.email');

