@extends('layouts.app')

@section('content')
    <div class="container">
        <h3 class="mb-4 py-2">Manajemen User</h3>

        <div class="mb-2">
            <a href="{{ route('users.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Tambah User
            </a>
        </div>

        {{-- ALERT MESSAGE --}}
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="card shadow-sm">
            <div class="card-body p-3 table-responsive">
                <table id="users-table" class="table table-striped table-hover align-middle mb-0 text-center">
                    <thead>
                        <tr>
                            <th style="width: 5%;">No</th>
                            <th style="width: 10%;">Profile</th>
                            <th>Username</th>
                            <th>Email</th>
                            <th style="width: 10%;">Akses</th>
                            <th style="width: 18%;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($users as $u)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>
                                    <img src="{{ $u->photo ? asset($u->photo) : asset('images/default.jpg') }}"
                                        alt="Foto {{ $u->username }}" width="50" height="50" class="rounded-circle"
                                        style="object-fit: cover;">
                                </td>
                                <td>{{ $u->username }}</td>
                                <td>{{ $u->email }}</td>
                                <td class="text-capitalize">{{ $u->akses }}</td>
                                <td>
                                    <a href="{{ route('users.edit', $u->id) }}" class="btn btn-warning btn-sm me-2 mb-1">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                    <form action="{{ route('users.destroy', $u->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm mb-1"
                                            onclick="return confirm('Yakin hapus?')">
                                            <i class="fas fa-trash"></i> Hapus
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted">Belum ada data user.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('#users-table').DataTable({
                responsive: true,
                autoWidth: false,
            });
        });
    </script>
@endpush
