@extends('layouts.app')

@section('content')
    <div class="container">
        <h3 class="mb-4 py-2 ">Daftar Stok Mitra</h3>

        {{-- ALERT MESSAGE --}}
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        {{-- <div class="mb-2">
            <a href="{{ route('stoks.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Tambah Stok
            </a>
        </div> --}}


        <div class="card shadow-sm">
            <div class="card-body p-3 table-responsive">
                <table id="stok-table" class="table table-striped table-hover align-middle mb-0 nowrap w-100">
                    <thead>
                        <tr>
                            <th style="width:5%;">No</th>
                            <th>Tanggal</th>
                            <th>Produk</th>
                            <th>Mitra</th>
                            <th class="text-center">Masuk</th>
                            <th class="text-center">Terjual</th>
                            <th class="text-center">Return</th>
                            <th class="text-center">Sisa</th>
                            {{-- <th>PJ</th> --}}
                            {{-- <th class="text-center" style="width:18%;">Aksi</th> --}}
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($stoks as $stok)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ \Carbon\Carbon::parse($stok->date)->format('d/m/Y') }}</td>
                                <td>{{ $stok->produk->name }}</td>
                                <td>{{ $stok->mitra->name }}</td>
                                <td class="text-center">{{ $stok->masuk }}</td>
                                <td class="text-center">{{ $stok->terjual }}</td>
                                <td class="text-center">{{ $stok->return }}</td>
                                <td class="text-center">{{ $stok->sisa }}</td>
                                {{-- <td>{{ $stok->mitra->user->username ?? '-' }}</td> --}}
                                {{-- <td class="text-center" style="white-space: nowrap;">
                                    <a href="{{ route('stoks.edit', $stok->id) }}" class="btn btn-warning btn-sm me-2">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                    <form id="delete-form-{{ $stok->id }}"
                                        action="{{ route('stoks.destroy', $stok->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="button" class="btn btn-danger btn-sm"
                                            onclick="confirmDelete({{ $stok->id }})">
                                            <i class="fas fa-trash"></i> Hapus
                                        </button>
                                    </form>
                                </td> --}}
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('#stok-table').DataTable({
                responsive: true,
                autoWidth: false,
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.11.5/i18n/Indonesian.json'
                }
            });
        });

        function confirmDelete(id) {
            Swal.fire({
                title: 'Apakah kamu yakin?',
                text: "Data yang dihapus tidak bisa dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
@endpush
