@extends('layouts.app')

@section('content')
    <div class="container">
        <h4 class="mb-4 py-2">Edit Data Stok</h4>

        <div class="card shadow-sm mt-3">
            <div class="card-body">

                {{-- Error Message --}}
                @if ($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    @foreach ($errors->all() as $error)
                        {{ $error }}<br>
                    @endforeach
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif

                <form action="{{ route('stoks.update', $stok->id) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="row mb-3">
                        {{-- Produk --}}
                        <div class="col-md-4">
                            <label for="produk_id" class="form-label">Produk</label>
                            <select name="produk_id" class="form-control" required>
                                <option value="">-- Pilih Produk --</option>
                                @foreach ($produks as $produk)
                                    <option value="{{ $produk->id }}"
                                        {{ old('produk_id', $stok->produk_id) == $produk->id ? 'selected' : '' }}>
                                        {{ $produk->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        {{-- Mitra --}}
                        <div class="col-md-4">
                            <label for="mitra_id" class="form-label">Mitra</label>
                            <select name="mitra_id" class="form-control" required>
                                <option value="">-- Pilih Mitra --</option>
                                @foreach ($mitras as $mitra)
                                    <option value="{{ $mitra->id }}"
                                        {{ old('mitra_id', $stok->mitra_id) == $mitra->id ? 'selected' : '' }}>
                                        {{ $mitra->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Total Stok Produk Ini</label>
                            <input type="number" class="form-control bg-light" readonly value="{{ $total_sisa ?? 0 }}">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="masuk" class="form-label">Tambah Stok Masuk</label>
                            <input type="number" name="masuk" id="masuk" class="form-control"
                                value="{{ old('masuk', $stok->masuk) }}" required>
                        </div>

                        <div class="col-md-4">
                            <label for="terjual" class="form-label">Jumlah Terjual</label>
                            <input type="number" name="terjual" id="terjual" class="form-control"
                                value="{{ old('terjual', $stok->terjual) }}">
                        </div>

                        <div class="col-md-4">
                            <label for="date" class="form-label">Tanggal</label>
                            <input type="date" name="date" id="date" class="form-control"
                            value="{{ old('date', date('Y-m-d')) }}" required>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="return" class="form-label">Return</label>
                            <input type="number" name="return" id="return" class="form-control"
                                value="{{ old('return', $stok->return) }}">
                        </div>

                        <div class="col-md-4">
                            <label for="sisa" class="form-label">Sisa Stok</label>
                            <input type="number" name="sisa" id="sisa" class="form-control bg-light" readonly
                                value="{{ old('sisa', $stok->sisa) }}">
                        </div>

                        {{-- Penanggung Jawab --}}
                        <div class="col-md-4">
                            <label for="user_id" class="form-label">Penanggung Jawab</label>
                            <select name="user_id" id="user_id" class="form-control">
                                <option value="">-- Pilih Penanggung Jawab --</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}" {{ $stok->mitra->user_id == $user->id ? 'selected' : '' }}>
                                        {{ $user->username }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        
                    </div>

                    <div class="mt-3">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update
                        </button>
                        <a href="{{ route('pengiriman.index') }}" class="btn btn-secondary ms-2">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function hitungSisa() {
            const masuk = parseInt(document.getElementById('masuk').value) || 0;
            const terjual = parseInt(document.getElementById('terjual').value) || 0;
            const retur = parseInt(document.getElementById('return').value) || 0;

            const sisa = masuk - terjual + retur;
            document.getElementById('sisa').value = sisa >= 0 ? sisa : 0;
        }

        document.getElementById('masuk').addEventListener('input', hitungSisa);
        document.getElementById('terjual').addEventListener('input', hitungSisa);
        document.getElementById('return').addEventListener('input', hitungSisa);
    </script>
@endpush
