@extends('layouts.app')

@section('content')
    <div class="container">
        <h2 class="mb-4 py-2">Detail Produk</h2>

        {{-- ALERT MESSAGE --}}
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="card">
            <div class="card-body">

                <div class="row justify-content-center mb-4">
                    <div class="col-12 col-md-6 text-center">
                        <img src="{{ $produk->image ? asset('storage/' . $produk->image) : asset('images/default.jpg') }}"
                            alt="Gambar Produk" class="img-fluid rounded shadow-sm mb-3"
                            style="max-height: 300px; width: auto; max-width: 100%; object-fit: cover;">
                    </div>
                </div>

                <div class="row g-3">
                    <div class="col-12 col-md-6">
                        <label class="form-label fw-bold">Nama Produk</label>
                        <p class="form-control-plaintext">{{ $produk->name }}</p>
                    </div>

                    <div class="col-12 col-md-6">
                        <label class="form-label fw-bold">Harga</label>
                        <p class="form-control-plaintext">Rp {{ number_format($produk->price, 0, ',', '.') }}</p>
                    </div>

                    <div class="col-12">
                        <label class="form-label fw-bold">Deskripsi</label>
                        <p class="form-control-plaintext">{{ $produk->explanation }}</p>
                    </div>
                </div>

                {{-- Tombol --}}
                <div class="mt-4 mb-3">
                    <a href="{{ route('produks.edit', $produk->id) }}" class="btn btn-warning me-2">
                        <i class="fas fa-edit me-1"></i> Edit
                    </a>

                    <form action="{{ route('produks.destroy', $produk->id) }}" method="POST" class="d-inline"
                        id="delete-form-{{ $produk->id }}">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-danger me-2" onclick="confirmDelete({{ $produk->id }})">
                            <i class="fas fa-trash me-1"></i> Hapus
                        </button>
                    </form>

                    <a href="{{ route('produks.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Kembali
                    </a>
                </div>


            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Yakin ingin menghapus?',
                text: "Data yang dihapus tidak dapat dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
@endpush
