@extends('layouts.app')

@section('content')
    <div class="container">
        <h2 class="mb-4 py-2">Edit Produk</h2>

        {{-- ALERT MESSAGE --}}
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="card">
            <div class="card-body">

                <form action="{{ route('produks.update', $produk->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="row justify-content-center mb-4">
                        <div class="col-12 col-md-6 text-center">
                            <img id="preview"
                                src="{{ $produk->image ? asset('storage/' . $produk->image) : asset('images/default.jpg') }}"
                                alt="Gambar Produk" class="img-fluid rounded shadow-sm mb-3"
                                style="max-height: 300px; width: auto; max-width: 100%; object-fit: cover;">
                            <input type="file" name="image" accept="image/*" onchange="previewImage(event)"
                                class="form-control @error('image') is-invalid @enderror">
                            <small class="text-muted">Kosongkan jika tidak ingin mengganti gambar</small>
                            @error('image')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="row g-3">
                        <div class="col-12 col-md-6">
                            <label for="name" class="form-label">Nama Produk</label>
                            <input type="text" id="name" name="name"
                                class="form-control @error('name') is-invalid @enderror"
                                value="{{ old('name', $produk->name) }}" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12 col-md-6">
                            <label for="price" class="form-label">Harga</label>
                            <input type="number" id="price" name="price"
                                class="form-control @error('price') is-invalid @enderror"
                                value="{{ old('price', $produk->price) }}" required>
                            @error('price')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label for="explanation" class="form-label">Deskripsi</label>
                            <textarea id="explanation" name="explanation" rows="4"
                                class="form-control @error('explanation') is-invalid @enderror" required>{{ old('explanation', $produk->explanation) }}</textarea>
                            @error('explanation')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="mt-4 mb-3">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-1"></i> Simpan
                        </button>
                        <a href="{{ route('produks.index') }}" class="btn btn-secondary ms-2">
                            <i class="fas fa-arrow-left me-1"></i> Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function previewImage(event) {
            const reader = new FileReader();
            reader.onload = function() {
                document.getElementById('preview').src = reader.result;
            };
            if (event.target.files[0]) {
                reader.readAsDataURL(event.target.files[0]);
            }
        }
    </script>
@endpush
