@extends('layouts.app')

@section('content')
    <div class="container">
      
        <h3 class="mb-4 py-2">Detail Mitra</h3>

        {{-- ALERT MESSAGE --}}
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="card shadow-sm">
            <div class="card-body">

                {{-- Gambar mitra --}}
                <div class="row justify-content-center mb-4">
                    @php
                        $imagePath = $mitra->image ? 'storage/' . $mitra->image : 'storage/mitras/default_mitra.jpg';
                    @endphp
                    <div class="col-12 col-sm-8 col-md-6 col-lg-4 text-center">
                        <img src="{{ asset($imagePath) }}" alt="Foto Mitra" class="img-fluid rounded shadow-sm"
                            style="max-height: 300px; width: auto;">
                    </div>
                </div>

                {{-- Detail data mitra --}}
                <div class="table-responsive mb-4">
                    <table class="table table-striped table-hover table-bordered">
                        <tbody>
                            <tr>
                                <th scope="row" style="width: 30%;">Nama</th>
                                <td>{{ $mitra->name }}</td>
                            </tr>
                            <tr>
                                <th scope="row">Latitude</th>
                                <td>{{ $mitra->latitude }}</td>
                            </tr>
                            <tr>
                                <th scope="row">Longitude</th>
                                <td>{{ $mitra->longitude }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                {{-- Produk & Stok --}}
                <h5 class="mb-3">Data Produk & Stok Mitra</h5>
                {{-- @foreach ($stok->unique('id') as $s)
                    <button class="btn btn-outline-primary btn-sm mb-2" type="button" data-toggle="collapse"
                        data-target="#stokCollapse{{ $s->id }}" aria-expanded="false"
                        aria-controls="stokCollapse{{ $s->id }}">
                        <i class="fas fa-box-open"></i> Lihat Data {{ $s->id }}
                    </button>
                @endforeach --}}
                
                @foreach ($mitra->produks as $index => $produk)
                    <div class="mb-3">
                        <button class="btn btn-outline-primary btn-sm mb-2" type="button" data-toggle="collapse"
                            data-target="#stokCollapse{{ $index }}" aria-expanded="false"
                            aria-controls="stokCollapse{{ $index }}">
                            <i class="fas fa-box-open"></i> Lihat Data {{ $produk->name }}
                        </button>
                        @if (Auth::user()->akses== 'sales')
                        <a href="/pengiriman/create?idproduk={{ $produk->id }}&mitra_id={{ $mitra->id }}&sales_id={{ Auth::user()->id ?? '' }}"
                             class="btn btn-success btn-sm mb-2">
                             <i class="fas fa-plus"></i> Tambah Data
                         </a>
                        @endif

                        <div class="collapse" id="stokCollapse{{ $index }}">
                            <div class="card card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Tanggal</th>
                                                <th>Stok</th>
                                                <th>Terjual</th>
                                                <th>Return</th>
                                                <th>Sisa</th>
                                                <th>Pengirim</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                            $adaData = false;
                                        @endphp
                                        
                                        @forelse ($produk->stoks as $item)
                                            @if ($item->produk_id == $produk->id && $item->mitra_id == $mitra->id)
                                                @php $adaData = true; @endphp
                                                <tr>
                                                    <td>{{ \Carbon\Carbon::parse($item->date)->format('d/m/Y') }}</td>
                                                    <td>{{ $item->masuk }}</td>
                                                    <td>{{ $item->terjual }}</td>
                                                    <td>{{ $item->return }}</td>
                                                    <td>{{ $item->sisa }}</td>
                                                    <td>{{ $item->sales->username }}</td>
                                                </tr>
                                            @endif
                                        @empty
                                            <tr>
                                                <td colspan="5" class="text-center text-muted">Tidak ada data stok.</td>
                                            </tr>
                                        @endforelse
                                        
                                        @if (!$adaData)
                                            <tr>
                                                <td colspan="5" class="text-center text-muted">Tidak ada data stok.</td>
                                            </tr>
                                        @endif
                                        
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach

                <a href="{{ route('mitras.index') }}" class="btn btn-secondary mt-4">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
            </div>
        </div>
    </div>
@endsection
