@extends('layouts.app')

@section('content')
<div class="container">
    <h1 class="mb-4 py-2">Daftar Mitra Anda</h1>

    <div class="card shadow-sm">
        <div class="card-body p-3 table-responsive">
            <table id="pengiriman" class="table table-striped table-hover align-middle mb-0">
                <thead class="">
                <tr>
                    <th>No</th>
                    <th>Nama Mitra</th>
                    <th>Gambar</th>
                    <th>Latitude</th>
                    <th>Longitude</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($mitras as $mitra)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $mitra->name }}</td>
                    <td>
                        @if ($mitra->image)
                        <img src="{{ asset('storage/' . $mitra->image) }}" alt="Foto Mitra" width="70">
                        @else
                            <span class="text-muted">No Image</span>
                        @endif
                    </td>
                    <td>{{ $mitra->latitude }}</td>
                    <td>{{ $mitra->longitude }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="text-muted">Belum ada data mitra.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
