@extends('layouts.app')

@section('content')
    <div class="container">
        <h3 class="mb-4 py-2">Daftar Mitra</h3>

        {{-- ALERT MESSAGE --}}
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="mb-2">
            <a href="{{ route('mitras.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Tambah Mitra
            </a>
        </div>

        <div class="card shadow-sm">
            <div class="card-body p-3 table-responsive">
                <table id="mitra-table" class="table table-striped table-hover align-middle mb-0">
                    <thead>
                        <tr>
                            <th style="width:5%;">No</th>
                            <th>Nama</th>
                            <th style="width:10%;">Gambar</th>
                            <th>Latitude</th>
                            <th>Longitude</th>
                            <th>Produk</th>
                            <th style="width:18%;" class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($mitras as $mitra)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $mitra->name }}</td>
                                <td class="text-center">
                                    @php
                                        $imagePath = $mitra->image
                                            ? 'storage/' . $mitra->image
                                            : 'storage/mitras/default_mitra.jpg';
                                    @endphp
                                    <img src="{{ asset($imagePath) }}" alt="Foto Mitra" width="70"
                                        class="rounded shadow-sm">
                                </td>
                                <td>{{ $mitra->latitude }}</td>
                                <td>{{ $mitra->longitude }}</td>
                                <td>
                                    @foreach ($mitra->produks as $produk)
                                        <span>{{ $produk->name }}</span> <br>
                                    @endforeach
                                </td>
                                <td class="text-center" style="white-space: nowrap;">
                                    <!-- Tombol buka modal -->
                                    {{-- @if (Auth::user()->akses == 'admin')
                                        <button type="button" class="btn btn-secondary btn-sm me-2" data-toggle="modal"
                                            data-target="#produkModal-{{ $mitra->id }}">
                                            <i class="fas fa-cubes"></i> Atur Produk
                                        </button>
                                    @endif --}}

                                    @if (in_array(Auth::user()->akses, ['admin', 'sales']))
                                        <button type="button" class="btn btn-secondary btn-sm me-2" data-toggle="modal"
                                            data-target="#produkModal-{{ $mitra->id }}">
                                            <i class="fas fa-cubes"></i> Atur Produk
                                        </button>
                                    @endif

                                    <a href="{{ route('mitras.show', $mitra->id) }}" class="btn btn-info btn-sm me-2">
                                        <i class="fas fa-eye"></i> Detail
                                    </a>

                                    @if (Auth::user()->akses == 'admin')
                                        <a href="{{ route('mitras.edit', $mitra->id) }}"
                                            class="btn btn-warning btn-sm me-2">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <form id="delete-form-{{ $mitra->id }}"
                                            action="{{ route('mitras.destroy', $mitra->id) }}" method="POST"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="button" class="btn btn-danger btn-sm"
                                                onclick="confirmDelete({{ $mitra->id }})">
                                                <i class="fas fa-trash"></i> Hapus
                                            </button>
                                        </form>
                                    @endif


                                </td>


                            </tr>
                        @endforeach

                        {{-- @if (Auth::user()->akses == 'admin') --}}
                        @if (in_array(Auth::user()->akses, ['admin', 'sales']))
                            @foreach ($mitras as $mitra)
                                <!-- Modal Atur Produk -->
                                <div class="modal fade" id="produkModal-{{ $mitra->id }}" tabindex="-1"
                                    aria-labelledby="produkModalLabel-{{ $mitra->id }}" aria-hidden="true">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <form action="{{ route('mitras.setProduk', $mitra->id) }}" method="POST">
                                                @csrf
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="produkModalLabel-{{ $mitra->id }}">Atur
                                                        Produk untuk: {{ $mitra->name }}</h5>
                                                    <!-- Tombol close modal -->
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="row">
                                                        <input type="hidden" name="mitra_id" value="{{ $mitra->id }}">
                                                        @foreach ($produks as $produk)
                                                            <div class="col-md-4 mb-2">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="checkbox"
                                                                        {{ $mitra->produks->contains($produk->id) ? 'checked' : '' }}
                                                                        name="produk_ids[]" value="{{ $produk->id }}">
                                                                    <label
                                                                        class="form-check-label">{{ $produk->name }}</label>
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    {{-- <button type="button" class="btn btn-secondary"
                                                data-bs-dismiss="modal">Batal</button> --}}
                                                    <button type="submit" class="btn btn-primary">Simpan</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif


                    </tbody>
                </table>
            </div>
        </div>
    </div> <!-- Penutup container -->

@endsection


@push('scripts')
    <script>
        $(document).ready(function() {
            $('#mitra-table').DataTable({
                responsive: true,
                autoWidth: false,
            });
        });

        function confirmDelete(id) {
            Swal.fire({
                title: 'Apakah kamu yakin?',
                text: "Data yang dihapus tidak bisa dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            })
        }
    </script>
@endpush
