@extends('layouts.app')

@section('content')
    <div class="container">
        <h3 class="mb-4 py-2">Edit Mitra</h3>


        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="card">
            <div class="card-body">
                <form action="{{ route('mitras.update', $mitra->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="mb-3 text-center">
                        @php
                        $sessionKey = 'uploaded_image_edit_' . $mitra->id;
                        $uploadedImage = session($sessionKey);
                        $imagePath = 'storage/mitras/default_mitra.jpg';
                        if ($uploadedImage) {
                            $imagePath = 'storage/' . $uploadedImage;
                        } elseif ($mitra->image) {
                            $imagePath = 'storage/' . $mitra->image;
                        }
                    @endphp
                    
                        <img id="preview-image" src="{{ asset($imagePath) }}" alt="Foto Mitra"
                            class="img-fluid rounded shadow-sm mb-3" style="max-height: 300px;">
                        <input type="file" name="image" accept="image/*" onchange="previewImage(event)"
                            class="form-control">
                    </div>

                    <div class="mb-3">
                        <label for="name" class="form-label">Nama Mitra</label>
                        <input type="text" id="name" name="name" class="form-control"
                            value="{{ old('name', $mitra->name) }}" required autofocus>
                    </div>

                    {{-- @if (auth()->user()->isAdmin())
                        <label for="user_id" class="form-label">Pilih Sales</label>
                        <select name="user_id" id="user_id" class="form-control" required>
                            <option value="">-- Pilih Sales --</option>
                            @foreach ($sales as $salesUser)
                                <option value="{{ $salesUser->id }}"
                                    {{ (old('user_id') ?? $mitra->user_id) == $salesUser->id ? 'selected' : '' }}>
                                    {{ $salesUser->username }}
                                </option>
                            @endforeach
                        </select>
                    @endif --}}


                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="latitude" class="form-label">Latitude</label>
                            <input type="text" id="latitude" name="latitude" class="form-control"
                                value="{{ old('latitude', $mitra->latitude) }}">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="longitude" class="form-label">Longitude</label>
                            <input type="text" id="longitude" name="longitude" class="form-control"
                                value="{{ old('longitude', $mitra->longitude) }}">
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Pilih Lokasi di Peta</label>
                        <div id="map" style="height: 400px;" class="rounded shadow-sm"></div>
                    </div>

                    <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Edit</button>
                    <a href="{{ route('mitras.index') }}" class="btn btn-secondary ms-2"><i
                            class="fas fa-arrow-left me-1"></i> Kembali</a>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    {{-- Leaflet Map --}}
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.3/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.9.3/dist/leaflet.js"></script>

    <script>
        function previewImage(event) {
            const reader = new FileReader();
            reader.onload = function() {
                document.getElementById('preview-image').src = reader.result;
            };
            reader.readAsDataURL(event.target.files[0]);
        }

        const latInput = document.getElementById('latitude');
        const lngInput = document.getElementById('longitude');

        const initialLat = parseFloat(latInput.value) || -6.2;
        const initialLng = parseFloat(lngInput.value) || 106.8166;

        const map = L.map('map').setView([initialLat, initialLng], 13);

        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap',
            maxZoom: 18,
        }).addTo(map);

        const marker = L.marker([initialLat, initialLng], {
            draggable: true
        }).addTo(map);

        map.on('click', function(e) {
            const {
                lat,
                lng
            } = e.latlng;
            marker.setLatLng([lat, lng]);
            latInput.value = lat;
            lngInput.value = lng;
        });

        marker.on('dragend', function(e) {
            const {
                lat,
                lng
            } = marker.getLatLng();
            latInput.value = lat;
            lngInput.value = lng;
        });

        setTimeout(() => {
            map.invalidateSize();
        }, 400);
    </script>
@endpush
