{{-- resources/views/layouts/navbar.blade.php --}}
<nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button">
                <i class="fas fa-bars"></i>
            </a>
        </li>
    </ul>

    <!-- Notifikasi Lonceng -->
    <ul class="navbar-nav ml-auto">
        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="far fa-bell"></i>
                @if (!empty($stokMenipis) && $stokMenipis->count())
                    <span class="badge badge-danger navbar-badge">{{ $stokMenipis->count() }}</span>
                @endif
            </a>
            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                <span class="dropdown-header">
                    {{ $stokMenipis->count() }} Produk stok menipis
                </span>

                <div class="dropdown-divider"></div>

                @forelse ($stokMenipis as $item)
                    <a href="#" class="dropdown-item">
                        <i class="fas fa-box text-warning mr-2"></i>
                        <strong>{{ is_array($item) ? $item['produk_nama'] : $item->produk_nama ?? $item->produk->name }}</strong>
                        <br>
                        <small>
                            Mitra:
                            {{ is_array($item) ? $item['mitra_nama'] : $item->mitra_nama ?? $item->mitra->name }}<br>
                            Sisa: <span class="text-danger">
                                {{ is_array($item) ? $item['sisa'] : $item->sisa }}
                            </span>
                            / Min:
                            {{ is_array($item) ? $item['minimum_stok'] : $item->minimum_stok ?? $item->produk->minimum_stok }}
                        </small>
                    </a>
                    <div class="dropdown-divider"></div>
                @empty
                    <div class="dropdown-item text-muted">Tidak ada notifikasi</div>
                @endforelse

                <a href="{{ route('pengiriman.index') }}" class="dropdown-item dropdown-footer">
                    <i class="fas fa-truck mr-1"></i> Lihat semua pengiriman
                </a>
            </div>
        </li>



        <!-- Logout Button -->
        <li class="nav-item">
            <a class="nav-link" href="#"
                onclick="event.preventDefault(); if(confirm('Apakah Anda yakin ingin keluar dari aplikasi?')) document.getElementById('logout-form').submit();">
                Logout <i class="fas fa-sign-out-alt"></i>
            </a>
            <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                @csrf
            </form>
        </li>
    </ul>
</nav>
