@extends('layouts.app')

@section('content')
    <div class="container">
        <h3 class="mb-4 py-2">Laporan Pengiriman Stok</h3>

        {{-- ALERT MESSAGE --}}
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        {{-- <a href="{{ route('pengiriman.create') }}" class="btn btn-primary mb-2"><i class="fas fa-plus"></i> Tambah Pengiriman</a> --}}
        {{-- Tombol Export Excel hanya untuk Admin --}}
        @if (Auth::user()->akses == 'admin')
            <a href="{{ route('pengiriman.export') }}" class="btn btn-success mb-2">
                <i class="fas fa-file-excel me-1"></i> Export Excel
            </a>
        @endif


        <div class="card shadow-sm">
            <div class="card-body p-3 table-responsive">
                <table id="pengiriman" class="table table-striped table-hover align-middle mb-0">
                    <thead>
                        <tr>
                            <th style="width:5%;">No</th>
                            <th>Tanggal</th>
                            <th>Produk</th>
                            <th>Mitra</th>
                            <th>Masuk</th>
                            <th>Terjual</th>
                            <th>Return</th>
                            <th>Sisa</th>
                            <th>Harga Satuan</th>
                            <th>Total Harga</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php $totalKeseluruhan = 0; @endphp

                        @foreach ($stoks as $item)
                            {{-- @php
                                $jumlah_terjual_bersih = max(0, $item->terjual - $item->return);
                                $sisa = max(0, $item->masuk - $item->terjual - $item->return);
                                $totalHargaItem = $item->produk->price * $jumlah_terjual_bersih;
                                $totalKeseluruhan += $totalHargaItem;
                            @endphp --}}
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ \Carbon\Carbon::parse($item->date)->format('d/m/Y') }}</td>
                                <td>{{ $item->produk->name }}</td>
                                <td>{{ $item->mitra->name }}</td>
                                <td>{{ $item->masuk }}</td>
                                <td>{{ $item->terjual }}</td>
                                <td>{{ $item->return }}</td>
                                <td>{{ $item->sisa }}</td>
                                <td>Rp{{ number_format($item->produk->price, 0, ',', '.') }}</td>
                                <td>Rp{{ number_format($item->terjual * $item->produk->price, 0, ',', '.') }}</td>
                                <td>
                                    @if (Auth::user()->akses == 'admin')
                                        <a href="{{ route('pengiriman.edit', $item->id) }}"
                                            class="btn btn-warning btn-sm me-2 mb-1">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <form id="delete-form-{{ $item->id }}"
                                            action="{{ route('pengiriman.destroy', $item->id) }}" method="POST"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="button" class="btn btn-danger btn-sm"
                                                onclick="confirmDelete({{ $item->id }})">
                                                <i class="fas fa-trash"></i> Hapus
                                            </button>
                                        </form>
                                    @else
                                        <a href="{{ route('mitras.show', $item->mitra->id) }}"
                                            class="btn btn-info btn-sm me-2">
                                            <i class="fas fa-eye"></i> Detaile
                                        </a>
                                    @endif

                                </td>
                            </tr>
                            @php
                                $total = $item->terjual * $item->produk->price;
                                $totalKeseluruhan = $totalKeseluruhan + $total;
                            @endphp
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="8" class="text-end"><strong>Total Keseluruhan</strong></td>
                            <td></td>
                            <td><strong>Rp{{ number_format($totalKeseluruhan, 0, ',', '.') }}</strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('#pengiriman').DataTable({
                responsive: true,
                autoWidth: false,
                order: [
                    [0, 'asc']
                ],
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.11.5/i18n/Indonesian.json'
                }
            });
        });

        function confirmDelete(id) {
            Swal.fire({
                title: 'Apakah kamu yakin?',
                text: "Data yang dihapus tidak bisa dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            })
        }
    </script>
@endpush
