@extends('layouts.app')

@section('content')
    <div class="container">
        <h3 class="mb-4 py-2">Edit Data Pengiriman Stok</h3>

        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        <div class="card shadow-sm">
            <div class="card-body">
                <form action="{{ route('pengiriman.update', $pengiriman->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="produk_id" class="form-label">Produk</label>
                            <select class="form-control" id="produk_id" name="produk_id" required>
                                <option value="" disabled>-- Pilih Produk --</option>
                                @foreach ($produks as $produk)
                                    <option value="{{ $produk->id }}"
                                        {{ old('produk_id', $pengiriman->produk_id) == $produk->id ? 'selected' : '' }}>
                                        {{ $produk->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="mitra_id" class="form-label">Mitra</label>
                            <select class="form-control" id="mitra_id" name="mitra_id" required>
                                <option value="" disabled>-- Pilih Mitra --</option>
                                @foreach ($mitras as $mitra)
                                    <option value="{{ $mitra->id }}"
                                        {{ old('mitra_id', $pengiriman->mitra_id) == $mitra->id ? 'selected' : '' }}>
                                        {{ $mitra->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Total Sisa Sebelumnya</label>
                            <input type="number" class="form-control bg-light" id="total_sisa_all_display" readonly
                                value="{{ $sisa }}" data-sisa-awal="{{ $sisa }}">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="masuk" class="form-label">Jumlah Masuk</label>
                            <input type="number" min="0" class="form-control" id="masuk" name="masuk"
                                value="{{ old('masuk', $pengiriman->masuk) }}" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="terjual" class="form-label">Jumlah Terjual</label>
                            <input type="number" min="0" class="form-control" id="terjual" name="terjual"
                                value="{{ old('terjual', $pengiriman->terjual) }}">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="date" class="form-label">Tanggal</label>
                            <input type="date" class="form-control" id="date" name="date"
                                value="{{ old('date', $pengiriman->date) }}" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="return" class="form-label">Return</label>
                            <input type="number" min="0" class="form-control" id="return" name="return"
                                value="{{ old('return', $pengiriman->return) }}">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="sisa" class="form-label">Sisa </label>
                            <input type="text" class="form-control" id="sisa" name="sisa"
                                value="{{ old('sisa', $pengiriman->sisa) }}" readonly>
                        </div>
                        @if (Auth::user()->akses === 'sales')
                            <input type="hidden" name="sales_id" value="{{ Auth::id() }}">
                        @else
                            <div class="col-md-4 mb-3">
                                <label for="sales_id" class="form-label">Penanggung Jawab</label>
                                <select name="sales_id" id="sales_id" class="form-control" required>
                                    <option value="">Pilih Penanggung Jawab</option>
                                    @foreach ($users as $user)
                                        <option value="{{ $user->id }}"
                                            {{ (int) old('sales_id', $pengiriman->sales_id ?? null) === $user->id ? 'selected' : '' }}>
                                            {{ $user->username }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        @endif


                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i> Update
                    </button>
                    <a href="{{ route('pengiriman.index') }}" class="btn btn-secondary ms-2">
                        <i class="fas fa-arrow-left me-1"></i> Kembali
                    </a>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        let lastValidSisa = 0; // simpan nilai sisa terakhir yang valid

        function hitungSisa() {
            const totalSisaAwal = parseInt(document.getElementById('total_sisa_all_display').getAttribute(
                'data-sisa-awal')) || 0;
            const masuk = parseInt(document.getElementById('masuk').value) || 0;
            const terjual = parseInt(document.getElementById('terjual').value) || 0;
            const retur = parseInt(document.getElementById('return').value) || 0;

            // Hitung sisa
            const sisaMitra = totalSisaAwal + masuk - terjual - retur;

            if (sisaMitra < 0) {
                alert('Perhitungan stok menghasilkan nilai negatif! Periksa jumlah masuk, terjual, dan return.');
                // Kembalikan ke nilai sebelumnya
                document.getElementById('sisa').value = lastValidSisa;
                return;
            }

            // Update input dan simpan nilai terakhir yang valid
            document.getElementById('sisa').value = sisaMitra;
            lastValidSisa = sisaMitra;
        }

        ['masuk', 'terjual', 'return'].forEach(id => {
            document.getElementById(id).addEventListener('input', hitungSisa);
        });

        window.addEventListener('DOMContentLoaded', () => {
            // Hitung pertama kali dan set nilai awal yang valid
            hitungSisa();
            lastValidSisa = parseInt(document.getElementById('sisa').value) || 0;
        });
    </script>
@endpush
