@extends('layouts.app')

@section('content')
    <div class="container">
        <h3 class="mb-4 py-2">Tambah Data Pengiriman Stok</h3>

        {{-- ALERT MESSAGE --}}
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {!! implode('<br>', $errors->all()) !!}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="card shadow-sm">
            <div class="card-body">
                <form action="{{ route('pengiriman.store') }}" method="POST">
                    @csrf

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="produk_id" class="form-label">Produk</label>
                            <select class="form-control" id="produk_id" name="produk_id" required>
                                <option value="{{ $produk->id }}">{{ $produk->name }}</option>
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="mitra_id" class="form-label">Mitra</label>
                            <select class="form-control" id="mitra_id" name="mitra_id" required>
                                <option value="{{ $mitra->id }}">{{ $mitra->name }}</option>
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label class="form-label">Total Sisa Stok</label>
                            <input type="number" class="form-control bg-light" id="total_sisa_all_display" readonly
                                value="{{ $sisa }}"
                                data-sisa-awal="{{ $sisa }}">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="masuk" class="form-label">Jumlah Masuk</label>
                            <input type="number" min="0" class="form-control" id="masuk" name="masuk"
                                value="{{ old('masuk', 0) }}" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="terjual" class="form-label">Jumlah Terjual</label>
                            <input type="number" min="0" class="form-control" id="terjual" name="terjual"
                                value="{{ old('terjual', 0) }}">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="date" class="form-label">Tanggal</label>
                            <input type="date" class="form-control" id="date" name="date"
                                value="{{ old('date', now()->format('Y-m-d')) }}" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="return" class="form-label">Return</label>
                            <input type="number" min="0" class="form-control" id="return" name="return"
                                value="{{ old('return', 0) }}">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="sisa" class="form-label">Sisa</label>
                            <input type="text" class="form-control" id="sisa" name="sisa"
                                value="{{ old('sisa', 0) }}" readonly>
                        </div>

                        @if (Auth::user()->akses === 'sales')
                            <input type="hidden" name="sales_id" value="{{ Auth::id() }}">
                        @else
                            <div class="col-md-4 mb-3">
                                <label for="sales_id" class="form-label">Penanggung Jawab</label>
                                <select name="sales_id" id="sales_id" class="form-control" required>
                                    <option value="">Pilih Penanggung Jawab</option>
                                    @foreach ($users as $user)
                                        <option value="{{ $user->id }}"
                                            {{ old('sales_id', $userTerpilih->id ?? '') == $user->id ? 'selected' : '' }}>
                                            {{ $user->username }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        @endif
                    </div>

                    <div class="mt-3">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-1"></i> Simpan
                        </button>
                        <a href="{{ route('pengiriman.index') }}" class="btn btn-secondary ms-2">
                            <i class="fas fa-arrow-left me-1"></i> Kembali
                        </a>
                    </div>
                    
                    
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        let lastValidSisa = 0; // simpan nilai sisa terakhir yang valid

        function hitungSisa() {
            const totalSisaAwal = parseInt(document.getElementById('total_sisa_all_display').getAttribute('data-sisa-awal')) || 0;
            const masuk = parseInt(document.getElementById('masuk').value) || 0;
            const terjual = parseInt(document.getElementById('terjual').value) || 0;
            const retur = parseInt(document.getElementById('return').value) || 0;

            // Hitung sisa
            const sisaMitra = totalSisaAwal + masuk - terjual - retur;

            if (sisaMitra < 0) {
                alert('Perhitungan stok menghasilkan nilai negatif! Periksa jumlah masuk, terjual, dan return.');
                // Kembalikan ke nilai sebelumnya
                document.getElementById('sisa').value = lastValidSisa;
                return;
            }

            // Update input dan simpan nilai terakhir yang valid
            document.getElementById('sisa').value = sisaMitra;
            lastValidSisa = sisaMitra;
        }

        ['masuk', 'terjual', 'return'].forEach(id => {
            document.getElementById(id).addEventListener('input', hitungSisa);
        });

        window.addEventListener('DOMContentLoaded', () => {
            // Hitung pertama kali dan set nilai awal yang valid
            hitungSisa();
            lastValidSisa = parseInt(document.getElementById('sisa').value) || 0;
        });
    </script>
@endpush
