@include('layouts.authup')

<body class="hold-transition register-page">
<div class="register-box">
  {{-- <div class="register-logo mb-2">
    <b>KonsiTrack</b> Register
  </div> --}}

  <div class="card card-outline card-primary">
    <div class="card-header text-center">
      <h3 class="card-title">Buat Akun Baru</h3>
    </div>
    <div class="card-body">

      {{-- Flash error --}}
      @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
          {{ session('error') }}
          <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">&times;</button>
        </div>
      @endif

      @if(session('success'))
      <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        {{ session('success') }}
      </div>
    @endif

      <form action="{{ url('/register') }}" method="POST">
        @csrf

        {{-- Username --}}
        <div class="input-group mb-3">
          <input type="text" name="username" value="{{ old('username') }}"
                 class="form-control @error('username') is-invalid @enderror"
                 placeholder="Username" required>
          <div class="input-group-append">
            <div class="input-group-text"><span class="fas fa-user"></span></div>
          </div>
          @error('username')
            <div class="invalid-feedback d-block">{{ $message }}</div>
          @enderror
        </div>

        {{-- Email --}}
        <div class="input-group mb-3">
          <input type="email" name="email" value="{{ old('email') }}"
                 class="form-control @error('email') is-invalid @enderror"
                 placeholder="Email" required>
          <div class="input-group-append">
            <div class="input-group-text"><span class="fas fa-envelope"></span></div>
          </div>
          @error('email')
            <div class="invalid-feedback d-block">{{ $message }}</div>
          @enderror
        </div>

        {{-- Password --}}
        <div class="input-group mb-3">
          <input type="password" name="password"
                 class="form-control @error('password') is-invalid @enderror"
                 placeholder="Password" required>
          <div class="input-group-append">
            <div class="input-group-text"><span class="fas fa-lock"></span></div>
          </div>
          @error('password')
            <div class="invalid-feedback d-block">{{ $message }}</div>
          @enderror
        </div>

        {{-- Konfirmasi Password --}}
        <div class="input-group mb-3">
          <input type="password" name="password_confirmation"
                 class="form-control @error('password_confirmation') is-invalid @enderror"
                 placeholder="Konfirmasi Password" required>
          <div class="input-group-append">
            <div class="input-group-text"><span class="fas fa-lock"></span></div>
          </div>
          @error('password_confirmation')
            <div class="invalid-feedback d-block">{{ $message }}</div>
          @enderror
        </div>

        {{-- Tombol Submit --}}
        <div class="row mb-3">
          <div class="col-12">
            <button type="submit" class="btn btn-primary btn-block">Daftar</button>
          </div>
        </div>
      </form>

      <p class="mb-0">
        <a href="{{ route('login') }}" class="text-center">Sudah punya akun? Login</a>
      </p>

    </div>
  </div>
</div>

@include('layouts.authdwon')