@extends('layouts.app')

@section('content')
<div class="container">
    <h3 class="mb-4 py-2">Analitik Penjualan Mitra</h3>

    {{-- Grafik Penjualan --}}
    <div class="card mb-4">
        <div class="card-header">Grafik Penjualan per Mitra</div>
        <div class="card-body">
            <canvas id="penjualanChart" height="175"></canvas>
            <div class="mt-3 d-flex flex-wrap align-items-center">
                <span class="me-3"><i class="fas fa-square text-danger me-1"></i> Rendah</span>
                <span class="me-3"><i class="fas fa-square text-warning me-1"></i> Sedang</span>
                <span class="me-3"><i class="fas fa-square text-primary me-1"></i> Tinggi</span>
            </div>
        </div>
    </div>

    {{-- Peta Mitra --}}
    <div class="card">
        <div class="card-header">Peta Lokasi Mitra</div>
        <div class="card-body">
            <div id="mapMitra" style="height: 500px;"></div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
{{-- Leaflet --}}
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

{{-- Chart.js --}}
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    const mitras = @json($penjualan);

    // ========== CHART ==========
    const labels = mitras.map(item => item.mitra.name);
    const dataJumlah = mitras.map(item => parseInt(item.total));

    const backgroundColors = dataJumlah.map(jumlah => {
        if (jumlah <= 3) return 'rgba(255, 99, 132, 0.7)';    // merah
        if (jumlah <= 6) return 'rgba(255, 206, 86, 0.7)';   // kuning
        return 'rgba(54, 162, 235, 0.7)';                    // biru
    });

    const borderColors = dataJumlah.map(jumlah => {
        if (jumlah <= 3) return 'rgba(255, 99, 132, 1)';
        if (jumlah <= 6) return 'rgba(255, 206, 86, 1)';
        return 'rgba(54, 162, 235, 1)'
    });

    const ctx = document.getElementById('penjualanChart').getContext('2d');
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Total Penjualan (Terjual)',
                data: dataJumlah,
                backgroundColor: backgroundColors,
                borderColor: borderColors,
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            animation: {
                duration: 1000,
                easing: 'easeOutBounce'
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        precision: 0
                    }
                }
            }
        }
    });

    // ========== PETA ==========
    const map = L.map('mapMitra').setView([-7.0, 110.0], 6);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; OpenStreetMap contributors'
    }).addTo(map);

    mitras.forEach(item => {
        const mitra = item.mitra;
        if (mitra.latitude && mitra.longitude) {
            L.marker([parseFloat(mitra.latitude), parseFloat(mitra.longitude)])
                .addTo(map)
                .bindPopup(`
                    <strong>${mitra.name}</strong><br>
                    Latitude: ${mitra.latitude}<br>
                    Longitude: ${mitra.longitude}<br>
                    Total Penjualan: ${item.total}
                `);
        }
    });
</script>
@endsection
