<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class MitraSeeder extends Seeder
{
    public function run()
    {
        // Pastikan folder uploads/mitras ada
        if (!is_dir(public_path('uploads/mitras'))) {
            mkdir(public_path('uploads/mitras'), 0777, true);
        }

        // Copy gambar default ke uploads/mitras/
        $defaultImage = 'uploads/mitras/default.jpg';
        if (!file_exists(public_path($defaultImage))) {
            copy(public_path('default.jpg'), public_path($defaultImage));
        }

        foreach (range(1, 10) as $index) {
            DB::table('mitras')->insert([
                'name' => 'Mitra ' . $index,
                'image' => null,
                'latitude' => -6.2 + $index / 100,
                'longitude' => 106.8 + $index / 100,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
