<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stoks', function (Blueprint $table) {
            $table->id();

            $table->foreignId('sales_id')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('produk_id')->constrained('produks')->onDelete('cascade');
            $table->foreignId('mitra_id')->constrained('mitras')->onDelete('cascade');

            $table->date('date');
            $table->integer('masuk')->default(0);
            $table->integer('terjual')->default(0);
            $table->integer('return')->default(0);
            $table->integer('sisa')->default(0);

            $table->enum('jenis', ['pengiriman', 'penjualan', 'return'])->nullable(); // jenis aktivitas stok

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stoks');
    }
};
