<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Auth;
use App\Models\Stok;
use App\Observers\StokObserver;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Gunakan Bootstrap untuk pagination
        Paginator::useBootstrap();

        // Daftarkan observer jika ada
        Stok::observe(StokObserver::class);

        // Bagikan stok menipis ke semua view berdasarkan role
        View::composer('*', function ($view) {
            if (Auth::check()) {
                $user = Auth::user();

                $stokMenipis = match ($user->akses) {
                    'admin' => Stok::select(
                        'produks.name as produk_nama',
                        'mitras.name as mitra_nama',
                        'produks.minimum_stok',
                        'stoks.sisa'
                    )
                        ->join('produks', 'produks.id', '=', 'stoks.produk_id')
                        ->join('mitras', 'mitras.id', '=', 'stoks.mitra_id')
                        ->whereIn('stoks.id', function ($query) {
                            $query->selectRaw('MAX(stoks.id)')
                                ->from('stoks')
                                ->join('mitras', 'mitras.id', '=', 'stoks.mitra_id')
                                ->groupBy('stoks.produk_id', 'stoks.mitra_id');
                        })
                        ->whereColumn('stoks.sisa', '<=', 'produks.minimum_stok')
                        ->orderBy('mitras.name')
                        ->get(),

                    'sales' => Stok::select(
                        'produks.name as produk_nama',
                        'mitras.name as mitra_nama',
                        'produks.minimum_stok',
                        'stoks.sisa'
                    )
                        ->join('produks', 'produks.id', '=', 'stoks.produk_id')
                        ->join('mitras', 'mitras.id', '=', 'stoks.mitra_id')
                        ->whereIn('stoks.id', function ($query) {
                            $query->selectRaw('MAX(id)')
                                ->from('stoks')
                                ->groupBy('produk_id', 'mitra_id');
                        })
                        ->whereColumn('stoks.sisa', '<=', 'produks.minimum_stok')
                        ->orderBy('mitras.name')
                        ->get(),



                    default => collect()
                };

                $view->with('stokMenipis', $stokMenipis);
            }
        });
    }
}
