<?php 

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class UserCreatedNotification extends Notification
{
    use Queueable;

    public $password;

    public function __construct($password)
    {
        $this->password = $password;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        $loginUrl = url('/login');

        return (new MailMessage)
            ->subject('Akun Anda Telah Dibuat')
            ->greeting('Halo, ' . $notifiable->username . ' 👋')
            ->line('Akun Anda telah berhasil dibuat Selamat Bergabung!.')
            ->line('Email: ' . $notifiable->email)
            ->line('Password: ' . $this->password)
            ->action('Login Sekarang', $loginUrl)
            ->line('Segera login dan ganti password Anda untuk keamanan.');
    }
}
