<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Mitra extends Model
{
    use HasFactory;

    protected $table = 'mitras';
    protected $guarded = ['id'];

    /**
     * Relasi ke tabel users (pemilik mitra/sales)
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Relasi ke produk via tabel pivot mitra_produks
     */
    public function produks()
    {
        return $this->belongsToMany(Produk::class, 'mitra_produks');
    }

    /**
     * Relasi ke stok
     */
    public function stoks()
    {
        return $this->hasMany(Stok::class, 'mitra_id');
    }

    /**
     * (Opsional) Alias untuk relasi ke sales, kalau kamu pakai 'sales_id' di tabel mitras
     */
    public function sales()
    {
        return $this->belongsTo(User::class, 'sales_id');
    }
}
