<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Stok;
use App\Models\Mitra;
use App\Models\Produk;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $user = Auth::user();

        // Umum
        $mitra = Mitra::all();
        $produk = Produk::all();

        // ADMIN DASHBOARD
        if ($user->akses === 'admin') {
            $totalProduk = Produk::count();
            $totalMitra = Mitra::count();

            // Total semua stok tersedia dari seluruh mitra dan produk
            $sisaStokTerakhir = Stok::sum('sisa');

            // Tahun filter untuk grafik
            $tahunDipilih = $request->get('tahun');
            $daftarTahun = Stok::selectRaw('YEAR(date) as tahun')
                ->distinct()
                ->orderByDesc('tahun')
                ->pluck('tahun');

            // Grafik penjualan bulanan
            $penjualanQuery = Stok::selectRaw('MONTH(date) as bulan, YEAR(date) as tahun, SUM(terjual) as total');
            if ($tahunDipilih) {
                $penjualanQuery->whereYear('date', $tahunDipilih);
            }

            $penjualanData = $penjualanQuery
                ->groupByRaw('YEAR(date), MONTH(date)')
                ->orderByRaw('YEAR(date), MONTH(date)')
                ->get();

            $labelBulan = [];
            $dataTerjual = [];

            foreach ($penjualanData as $data) {
                $label = date('M', mktime(0, 0, 0, $data->bulan, 1)) . ' ' . $data->tahun;
                $labelBulan[] = $label;
                $dataTerjual[] = (int) $data->total;
            }

            if (empty($labelBulan)) {
                $labelBulan[] = 'Jan';
                $dataTerjual[] = 0;
            }

            // Stok menipis (produk-mitra dengan stok <= minimum)
            // $stokMenipis = Stok::select(
            //     'produks.name as produk_nama',
            //     'mitras.name as mitra_nama',
            //     'produks.minimum_stok',
            //     'stoks.sisa'
            // )
            //     ->join('produks', 'produks.id', '=', 'stoks.produk_id')
            //     ->join('mitras', 'mitras.id', '=', 'stoks.mitra_id')
            //     ->whereIn('stoks.id', function ($query) {
            //         $query->select(DB::raw('MAX(id)'))
            //             ->from('stoks')
            //             ->groupBy('produk_id', 'mitra_id');
            //     })
            //     ->whereColumn('stoks.sisa', '<=', 'produks.minimum_stok')
            //     ->orderBy('mitras.name')
            //     ->get();


            // Stok per produk per mitra (untuk tabel ringkasan)
            // Ambil stok terbaru (sisa terakhir) per produk dan mitra
            $stokPerProdukMitra = Stok::with(['produk', 'mitra'])
                ->get()
                ->groupBy(function ($stok) {
                    return $stok->produk_id . '|' . $stok->mitra_id;
                })
                ->map(function ($group) {
                    $stokTerbaru = $group->sortByDesc('id')->first(); // ambil stok terakhir
                    return [
                        'produk_nama' => $stokTerbaru->produk->name ?? '-',
                        'mitra_nama' => $stokTerbaru->mitra->name ?? '-',
                        'terjual' => $group->sum('terjual'),
                        'retur' => $group->sum('return'),
                        'sisa' => $stokTerbaru->sisa ?? 0,
                    ];
                })
                ->values();


            $totalStokTersedia = $stokPerProdukMitra->sum('sisa');


            return view('dashboard.index', compact(
                'totalProduk',
                'totalMitra',
                //'sisaStokTerakhir',
                'totalStokTersedia',
                'labelBulan',
                'dataTerjual',
                'daftarTahun',
                'tahunDipilih',
                //'stokMenipis',
                'stokPerProdukMitra',
                'mitra',
                'produk'
            ));
        }

        // Tambahkan di bagian SALES DASHBOARD
        if ($user->akses === 'sales') {
            // Semua produk yang punya stok
            $totalProdukSales = Produk::whereHas('stoks')->distinct()->count();

            // $stokMenipis = Stok::with(['produk', 'mitra'])
            //     ->get()
            //     ->groupBy(function ($stok) {
            //         return $stok->produk_id . '|' . $stok->mitra_id;
            //     })
            //     ->map(function ($group) {
            //         $latest = $group->sortByDesc('id')->first();

            //         if (
            //             $latest &&
            //             $latest->sisa <= ($latest->produk->minimum_stok ?? 0)
            //         ) {
            //             return [
            //                 'produk_nama' => $latest->produk->name ?? '-',
            //                 'mitra_nama' => $latest->mitra->name ?? '-',
            //                 'minimum_stok' => $latest->produk->minimum_stok ?? 0,
            //                 'sisa' => $latest->sisa,
            //             ];
            //         }

            //         return null;
            //     })
            //     ->filter()
            //     ->values();


            // Semua produk yang punya stok
            $produkSales = Produk::whereHas('stoks')->get();

            // Semua stok dari seluruh mitra
            $stokSales = Stok::with(['mitra', 'produk'])->get();

            // Grafik: Jumlah terjual per mitra
            $grafikTerjualSales = [];

            $stokSales->groupBy(function ($stok) {
                return $stok->mitra->name . '|' . $stok->produk->name;
            })->each(function ($group, $key) use (&$grafikTerjualSales) {
                [$mitra, $produk] = explode('|', $key);
                $totalTerjual = $group->sum('terjual');
            
                $grafikTerjualSales[] = [
                    'mitra' => $mitra,
                    'produk' => $produk,
                    'terjual' => $totalTerjual,
                ];
            });
            

            if (empty($labelMitraSales)) {
                $labelMitraSales[] = 'Tidak Ada';
                $dataTerjualSales[] = 0;
            }

            $terjualSales = $stokSales->sum('terjual');

            // Tabel per mitra & produk
            $tabelPenjualanSales = [];
            $totalReturSales = 0;

            $laporanPerProdukMitra = $stokSales->groupBy(function ($stok) {
                return $stok->mitra->name . '|' . $stok->produk->name;
            });

            foreach ($laporanPerProdukMitra as $key => $stokGroup) {
                [$mitraNama, $produkNama] = explode('|', $key);
                $jumlahTerjual = $stokGroup->sum('terjual');
                $jumlahRetur = $stokGroup->sum('return');
                $sisaTerakhir = $stokGroup->sortByDesc('id')->first()?->sisa ?? 0;

                $tabelPenjualanSales[] = [
                    'mitra' => $mitraNama,
                    'produk' => $produkNama,
                    'terjual' => $jumlahTerjual,
                    'retur' => $jumlahRetur,
                    'sisa' => $sisaTerakhir,
                ];

                $totalReturSales += $jumlahRetur;
            }

            return view('dashboard.index', compact(
                'totalProdukSales',
                //'stokMenipis',
                'produkSales',
                'labelMitraSales',
                'dataTerjualSales',
                'terjualSales',
                'tabelPenjualanSales',
                'totalReturSales',
                'grafikTerjualSales'
            ));
        }


        return redirect()->route('logout');
    }
}
