<?php

namespace App\Http\Controllers;

use App\Models\Stok;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

class AnalitikController extends Controller
{
    public function index()
{
    $penjualan = DB::table('mitras')
    ->leftJoin('stoks', 'mitras.id', '=', 'stoks.mitra_id')
    ->select(
        'mitras.id',
        'mitras.name',
        'mitras.latitude',
        'mitras.longitude',
        DB::raw('COALESCE(SUM(stoks.terjual), 0) as total')
    )
    ->groupBy('mitras.id', 'mitras.name', 'mitras.latitude', 'mitras.longitude')
    ->get()
    ->map(function ($item) {
        return [
            'mitra' => [
                'id' => $item->id,
                'name' => $item->name,
                'latitude' => $item->latitude,
                'longitude' => $item->longitude,
            ],
            'total' => $item->total,
        ];
    });

    return view('admin.analitik', compact('penjualan'));
}


}
