<?php

namespace App\Exports;

use Carbon\Carbon;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use App\Models\Stok;
use Illuminate\Support\Facades\Auth;

class PengirimanStokExport implements FromCollection, WithHeadings, WithMapping, WithStyles, WithEvents
{
    protected $data;
    protected $totalJumlahMasuk = 0;
    protected $totalHarga = 0;

    public function collection()
    {

        if(Auth::user()->akses == 'sales'){
            $this->data = Stok::with(['produk', 'mitra'])->where('sales_id', Auth::user()->id)->get();

        }else{
            $this->data = Stok::with(['produk', 'mitra'])->get();
        }
      

        return $this->data;
    }

    public function map($stok): array
    {
        // Hitung total harga = harga satuan * (terjual - return)
        $jumlahTerjualBersih = $stok->terjual ;
        if ($jumlahTerjualBersih < 0) {
            $jumlahTerjualBersih = 0;
        }

        $hargaSatuan = $stok->produk->price ?? 0;
        $totalHargaItem = $hargaSatuan * $jumlahTerjualBersih;

        // Akumulasi total
        $this->totalJumlahMasuk += ($stok->masuk + $stok->return);
        $this->totalHarga += $totalHargaItem;

        return [
            Carbon::parse($stok->date)->format('Y-m-d'),
            $stok->produk->name ?? '-',
            $stok->mitra->name ?? '-',
            $stok->masuk,
            $stok->terjual,
            $stok->return,
            $stok->sisa,
            'Rp' . number_format($hargaSatuan, 0, ',', '.'),
            'Rp' . number_format($totalHargaItem, 0, ',', '.'),
        ];
    }

    public function headings(): array
    {
        return [
            'Tanggal',
            'Produk',
            'Mitra',
            'Masuk',
            'Terjual',
            'Return',
            'Sisa',
            'Harga Satuan',
            'Total Harga',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        $sheet->getStyle('A1:I1')->applyFromArray([
            'font' => [
                'bold' => true,
                'color' => ['rgb' => 'FFFFFF'],
            ],
            'fill' => [
                'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                'startColor' => ['rgb' => '28a745'],
            ],
        ]);
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $rowCount = count($this->data) + 2; // header + data + 1 baris total

                $event->sheet->setCellValue("A{$rowCount}", 'Total');
                $event->sheet->mergeCells("A{$rowCount}:C{$rowCount}");

                // Total jumlah masuk di kolom D
                //$event->sheet->setCellValue("D{$rowCount}", $this->totalJumlahMasuk);

                // Total harga di kolom I, format rupiah
                $event->sheet->setCellValue("I{$rowCount}", 'Rp' . number_format($this->totalHarga, 0, ',', '.'));

                // Style baris total
                $event->sheet->getStyle("A{$rowCount}:I{$rowCount}")->applyFromArray([
                    'font' => ['bold' => true],
                    'fill' => [
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'startColor' => ['rgb' => 'F8F9FA'],
                    ],
                ]);
            },
        ];
    }
}
