

<?php $__env->startSection('content'); ?>
<div class="container">
    <h3 class="mb-4">Form Pengiriman Stok</h3>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($err); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('pengiriman-stok.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="mb-3">
            <label for="produk_id" class="form-label">Produk</label>
            <select name="produk_id" class="form-select" required>
                <option value="">-- Pilih Produk --</option>
                <?php $__currentLoopData = $produks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($produk->id); ?>" <?php echo e(old('produk_id') == $produk->id ? 'selected' : ''); ?>>
                        <?php echo e($produk->name); ?> - Rp<?php echo e(number_format($produk->price)); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="mitra_id" class="form-label">Mitra</label>
            <select name="mitra_id" class="form-select" required>
                <option value="">-- Pilih Mitra --</option>
                <?php $__currentLoopData = $mitras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mitra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($mitra->id); ?>" <?php echo e(old('mitra_id') == $mitra->id ? 'selected' : ''); ?>>
                        <?php echo e($mitra->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="jumlah" class="form-label">Jumlah</label>
            <input type="number" name="jumlah" class="form-control" min="1" required value="<?php echo e(old('jumlah')); ?>">
        </div>

        <div class="mb-3">
            <label for="tanggal_kirim" class="form-label">Tanggal Kirim</label>
            <input type="date" name="tanggal_kirim" class="form-control" required value="<?php echo e(old('tanggal_kirim')); ?>">
        </div>
        
        

        

        <button type="submit" class="btn btn-primary">Kirim</button>
        <a href="<?php echo e(route('pengiriman-stok.index')); ?>" class="btn btn-secondary">Batal</a>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/pengiriman-stok/create.blade.php ENDPATH**/ ?>