

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <h1 class="mb-4">Ringkasan Keuangan</h1>

    
    <h4>Total Pengiriman Per Mitra</h4>
    <div class="table-responsive mb-4">
        <table class="table table-bordered table-striped table-hover">
            <thead class="table-dark">
                <tr>
                    <th>No</th>
                    <th>Mitra</th>
                    <th>Total Masuk</th>
                    <th>Total Harga</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $totalPerMitra; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $mitra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($mitra->mitra_name); ?></td>
                    <td><?php echo e($mitra->total_masuk); ?></td>
                    <td>Rp <?php echo e(number_format($mitra->total_harga, 0, ',', '.')); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    
    <h4 class="mb-4">
        Total Keseluruhan Pengiriman: 
        <span class="text-primary">Rp <?php echo e(number_format($totalKeseluruhan, 0, ',', '.')); ?></span>
    </h4>

    
    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover align-middle">
            <thead class="table-secondary">
                <tr>
                    <th>No</th>
                    <th>Tanggal</th>
                    <th>Produk</th>
                    <th>Mitra</th>
                    <th>Masuk</th>
                    <th>Terjual</th>
                    <th>Sisa</th>
                    <th>Harga Satuan</th>
                    <th>Total Harga</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $stoks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stok): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($stok->date); ?></td>
                    <td><?php echo e($stok->produk->name ?? '-'); ?></td>
                    <td><?php echo e($stok->mitra->name ?? '-'); ?></td>
                    <td><?php echo e($stok->masuk); ?></td>
                    <td><?php echo e($stok->terjual); ?></td>
                    <td><?php echo e($stok->sisa); ?></td>
                    <td>Rp <?php echo e(number_format($stok->harga_satuan, 0, ',', '.')); ?></td>
                    <td>Rp <?php echo e(number_format($stok->total_harga, 0, ',', '.')); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <?php echo e($stoks->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/keuangan/index.blade.php ENDPATH**/ ?>