

<?php $__env->startSection('content'); ?>
<div class="container-fluid col-md-10 py-4">
    <div class="card">
        <div class="card-header bg-primary text-white">
            <h3 class="card-title mb-0">Tambah Mitra</h3>
        </div>

        <div class="card-body">
            <form action="<?php echo e(route('mitras.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div class="mb-3">
                    <label for="name" class="form-label">Nama Mitra</label>
                    <input type="text" class="form-control" id="name" name="name" value="<?php echo e(old('name')); ?>" required autofocus>
                </div>

                <div class="mb-3">
                    <label for="image" class="form-label">Gambar Mitra</label><br>
                    <img id="preview-image" src="https://via.placeholder.com/120x80?text=Preview" alt="Preview Image" width="120" class="rounded mb-2 shadow-sm">
                    <input class="form-control" type="file" id="image" name="image" accept="image/*">
                </div>

                <div class="mb-3">
                    <label for="user_id" class="form-label">Sales</label>
                    <select name="user_id" id="user_id" class="form-control" required>
                        <option value="">-- Pilih Sales --</option>
                        <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salesman): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($salesman->id); ?>"><?php echo e($salesman->username); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                
                

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="latitude" class="form-label">Latitude</label>
                        <input type="text" class="form-control" id="latitude" name="latitude" value="<?php echo e(old('latitude', '-6.2')); ?>">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="longitude" class="form-label">Longitude</label>
                        <input type="text" class="form-control" id="longitude" name="longitude" value="<?php echo e(old('longitude', '106.8166')); ?>">
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label">Pilih Lokasi di Peta</label>
                    <div id="map" style="height: 400px;" class="rounded shadow-sm"></div>
                </div>

                <div class="mt-4">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <a href="<?php echo e(route('mitras.index')); ?>" class="btn btn-secondary me-1">Kembali</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.3/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.9.3/dist/leaflet.js"></script>

<script>
    // Preview gambar saat memilih
    document.getElementById('image').onchange = function (event) {
        const [file] = event.target.files;
        if (file) {
            document.getElementById('preview-image').src = URL.createObjectURL(file);
        }
    };

    const latInput = document.getElementById('latitude');
    const lngInput = document.getElementById('longitude');

    const initialLat = parseFloat(latInput.value) || -6.2;
    const initialLng = parseFloat(lngInput.value) || 106.8166;

    const map = L.map('map').setView([initialLat, initialLng], 13);

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap',
        maxZoom: 18,
    }).addTo(map);

    const marker = L.marker([initialLat, initialLng], { draggable: true }).addTo(map);

    map.on('click', function(e) {
        const { lat, lng } = e.latlng;
        marker.setLatLng([lat, lng]);
        latInput.value = lat;
        lngInput.value = lng;
    });

    marker.on('dragend', function(e) {
        const { lat, lng } = marker.getLatLng();
        latInput.value = lat;
        lngInput.value = lng;
    });

    setTimeout(() => {
        map.invalidateSize();
    }, 400);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/mitras/create.blade.php ENDPATH**/ ?>