

<?php $__env->startSection('content'); ?>
<div class="container">
    <h3 class="mb-4">Stok Mitra</h3>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>


    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-bordered table-striped table-hover align-middle text-nowrap" id="stok-mitra-table">
                <thead class="table-dark">
                    <tr>
                        <th>No</th>
                        <th>Mitra</th>
                        <th>Produk</th>
                        <th>Masuk</th>
                        <th>Terjual</th>
                        <th>Return</th>
                        <th>Sisa</th>
                        <th>Tanggal</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $stoks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stok): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($stok->mitra_nama); ?></td>
                            <td><?php echo e($stok->produk_nama); ?></td>
                            <td><?php echo e($stok->total_masuk); ?></td>
                            <td><?php echo e($stok->total_terjual); ?></td>
                            <td><?php echo e($stok->total_return); ?></td>
                            <td><?php echo e($stok->total_sisa); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($stok->created_at ?? now())->format('d-m-Y')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/stok_mitra/index.blade.php ENDPATH**/ ?>