

<?php $__env->startSection('content'); ?>
<div class="container">
    <h3 class="mb-4">Stok Pusat</h3>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="text-end mb-3">
        <a href="<?php echo e(route('stok-pusat.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Tambah Stok Pusat
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-bordered table-striped" id="stok-pusat-table">
                <thead class="table-dark">
                    <tr>
                        <th>No</th>
                        <th>Tanggal</th>
                        <th>Produk</th>
                        <th>Masuk</th>
                        <th>Terjual</th>
                        <th>Return</th>
                        <th>Sisa</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $stoks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stok): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($stok->date)->format('d-m-Y')); ?></td>
                            <td><?php echo e($stok->produk->name ?? '-'); ?></td>
                            <td><?php echo e($stok->masuk); ?></td>
                            <td><?php echo e($stok->terjual); ?></td>
                            <td><?php echo e($stok->return); ?></td>
                            <td><?php echo e($stok->sisa); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/stok_pusat/index.blade.php ENDPATH**/ ?>