

<?php $__env->startSection('content'); ?>
<div class="container py-3">
    <h3>Edit Stok</h3>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <strong>Oops! Ada error:</strong>
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="card shadow-sm">
        <div class="card-body">
            <form action="<?php echo e(route('stoks.update', $stok->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="mb-3">
                    <label for="date" class="form-label">Tanggal</label>
                    <input type="date" class="form-control" id="date" name="date" value="<?php echo e(old('date', $stok->date)); ?>" required>
                </div>

                <div class="mb-3">
                    <label for="produk_id" class="form-label">Produk</label>
                    <select class="form-control" id="produk_id" name="produk_id" required>
                        <option value="" disabled>-- Pilih Produk --</option>
                        <?php $__currentLoopData = $produks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($produk->id); ?>" <?php echo e($stok->produk_id == $produk->id ? 'selected' : ''); ?>>
                                <?php echo e($produk->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label for="mitra_id" class="form-label">Mitra</label>
                    <select class="form-control" id="mitra_id" name="mitra_id" required>
                        <option value="" disabled>-- Pilih Mitra --</option>
                        <?php $__currentLoopData = $mitras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mitra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($mitra->id); ?>" <?php echo e($stok->mitra_id == $mitra->id ? 'selected' : ''); ?>>
                                <?php echo e($mitra->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label for="masuk" class="form-label">Masuk</label>
                        <input type="number" min="0" class="form-control" id="masuk" name="masuk" value="<?php echo e(old('masuk', $stok->masuk)); ?>" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="terjual" class="form-label">Terjual</label>
                        <input type="number" min="0" class="form-control" id="terjual" name="terjual" value="<?php echo e(old('terjual', $stok->terjual)); ?>" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="return" class="form-label">Return</label>
                        <input type="number" min="0" class="form-control" id="return" name="return" value="<?php echo e(old('return', $stok->return)); ?>" required>
                    </div>
                </div>

                <div class="mb-3">
                    <label for="sisa" class="form-label">Sisa</label>
                    <input type="text" class="form-control" id="sisa" name="sisa" value="<?php echo e(old('sisa', $stok->sisa)); ?>" readonly>
                </div>

                <button type="submit" class="btn btn-success">
                    <i class="fas fa-save"></i> Update
                </button>
                <a href="<?php echo e(route('stoks.index')); ?>" class="btn btn-secondary ms-2">Batal</a>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    function hitungSisa() {
        let masuk = parseInt(document.getElementById('masuk').value) || 0;
        let terjual = parseInt(document.getElementById('terjual').value) || 0;
        let ret = parseInt(document.getElementById('return').value) || 0;
        let sisa = masuk - terjual + ret;
        document.getElementById('sisa').value = sisa >= 0 ? sisa : 0;
    }

    document.getElementById('masuk').addEventListener('input', hitungSisa);
    document.getElementById('terjual').addEventListener('input', hitungSisa);
    document.getElementById('return').addEventListener('input', hitungSisa);
    window.addEventListener('load', hitungSisa);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/stoks/edit.blade.php ENDPATH**/ ?>