

<?php $__env->startSection('content'); ?>
<div class="container">
    <h3 class="mb-4">Riwayat Pengiriman Stok</h3>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <?php if(auth()->user()->akses === 'admin'): ?>
        <a href="<?php echo e(route('pengiriman-stok.create')); ?>" class="btn btn-primary mb-3">+ Pengiriman Baru</a>
    <?php endif; ?>

    <div class="table-responsive">
        <table class="table table-bordered table-hover align-middle text-nowrap">
            <thead class="table-light">
                <tr>
                    <th>No</th>
                    <th>Produk</th>
                    <th>Mitra</th>
                    <th>Jumlah</th>
                    <th>Harga Satuan</th>
                    <th>Total Harga</th>
                    <th>Tanggal Kirim</th>
                    <th>Tanggal Terima</th>
                    <th>Status</th>
                    <?php if(in_array(auth()->user()->akses, ['sales', 'admin'])): ?>
                        <th>Aksi</th>
                    <?php endif; ?>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $pengirimanStoks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($item->produk->name ?? '-'); ?></td>
                        <td><?php echo e($item->mitra->name ?? '-'); ?></td>
                        <td><?php echo e($item->jumlah); ?></td>
                        <td>Rp<?php echo e(number_format($item->harga_satuan, 0, ',', '.')); ?></td>
                        <td>Rp<?php echo e(number_format($item->total_harga, 0, ',', '.')); ?></td>
                        <td><?php echo e(\Carbon\Carbon::parse($item->tanggal_kirim)->format('d-m-Y')); ?></td>
                        <td>
                            <?php echo e($item->tanggal_terima 
                                ? \Carbon\Carbon::parse($item->tanggal_terima)->format('d-m-Y H:i') 
                                : '-'); ?>

                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($item->status === 'pending' ? 'warning' : 'success'); ?>">
                                <?php echo e(ucfirst($item->status)); ?>

                            </span>
                        </td>
                        <?php if(in_array(auth()->user()->akses, ['sales', 'admin'])): ?>
                        <td>
                            <?php if($item->status === 'pending'): ?>
                            <form action="<?php echo e(route('pengiriman-stok.konfirmasi', $item->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <button class="btn btn-sm btn-success" 
                                        onclick="return confirm('Yakin konfirmasi terima?')">
                                    Konfirmasi
                                </button>
                            </form>
                            <?php else: ?>
                                <span class="text-muted">Sudah Diterima</span>
                            <?php endif; ?>
                        </td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\konsitrack\resources\views/pengiriman-stok/index.blade.php ENDPATH**/ ?>