<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\StokController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\MitraController;
use App\Http\Controllers\SalesController;
use App\Http\Controllers\ProdukController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\AnalitikController;
use App\Http\Controllers\KeuanganController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SalesStokController;
use App\Http\Controllers\StokMitraController;
use App\Http\Controllers\StokPusatController;
use App\Http\Controllers\PengirimanStokController;

// ===== Dashboard =====
Route::get('/', [DashboardController::class, 'index'])->middleware(['auth'])->name('dashboard.index');

// ===== Admin Routes =====
Route::middleware(['auth', 'admin'])->group(function () {
    Route::resource('produks', ProdukController::class);
    Route::resource('stoks', StokController::class)->except(['create', 'store']);
    Route::resource('mitras', MitraController::class);
    Route::resource('stok-pusat', StokPusatController::class);
    Route::resource('stok-mitra', StokMitraController::class);
    Route::get('/keuangan', [KeuanganController::class, 'index'])->name('keuangan.index');


    // User management
    Route::get('/users', [UserController::class, 'index'])->name('users.index');
    Route::get('/users/create', [UserController::class, 'create'])->name('users.create');
    Route::post('/users', [UserController::class, 'store'])->name('users.store');
    Route::get('/users/{id}/edit', [UserController::class, 'edit'])->name('users.edit');
    Route::put('/users/{id}', [UserController::class, 'update'])->name('users.update');
    Route::delete('/users/{id}', [UserController::class, 'destroy'])->name('users.destroy');

    // Analitik
    Route::get('/analitik', [AnalitikController::class, 'index'])->name('admin.analitik');
});

// ===== Authenticated Routes (Semua User Login) =====
Route::middleware(['auth'])->group(function () {
    // Pengiriman Stok - PATCH konfirmasi harus didefinisikan sebelum resource
    Route::put('/pengiriman-stok/{id}/konfirmasi', [PengirimanStokController::class, 'konfirmasi'])->name('pengiriman-stok.konfirmasi');
    Route::resource('pengiriman-stok', PengirimanStokController::class)->only(['index', 'update', 'create', 'store']);

    // Riwayat & Mitra untuk sales
    // Route::get('riwayat-stok', [StokMitraController::class, 'riwayat'])->name('riwayat-stok.index');
    Route::patch('/riwayat-stok/terima/{id}', [StokMitraController::class, 'terima'])->name('riwayat-stok.terima');
    Route::get('/mitra-sales', [MitraController::class, 'salesMitra'])->name('mitra.sales');
    Route::get('/stok-mitra-sales', [SalesStokController::class, 'index'])->name('stok.mitra.index');

    // Profil
    Route::get('/profile', [ProfileController::class, 'index'])->name('profile.index');
    Route::get('/profile/edit', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::post('/profile/update', [ProfileController::class, 'update'])->name('profile.update');
    Route::get('/profile/password', [ProfileController::class, 'changePassword'])->name('profile.password');
    Route::post('/profile/password', [ProfileController::class, 'updatePassword'])->name('profile.password.update');
    Route::delete('/profile/delete', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// ===== Auth (Login, Register, Lupa Password) =====
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::get('/register', [AuthController::class, 'showRegisterForm'])->name('register');
Route::post('/register', [AuthController::class, 'register']);

Route::get('/forgot-password', [AuthController::class, 'showForgotForm'])->name('password.request');
Route::post('/forgot-password', [AuthController::class, 'sendResetLink'])->name('password.email');
Route::get('/reset-password/{token}', [AuthController::class, 'showResetForm'])->name('password.reset');
Route::post('/reset-password', [AuthController::class, 'resetPassword'])->name('password.update');
