@extends('layouts.app')

@section('content')
<div class="container">
    <h3 class="mt-3 mb-4">Detail Stok</h3>

    <div class="card shadow-sm">
        <div class="card-body">
            <table class="table table-bordered">
                <tr>
                    <th>Tanggal</th>
                    <td>{{ $stok->date }}</td>
                </tr>
                <tr>
                    <th>Produk</th>
                    <td>{{ $stok->produk->nama }}</td>
                </tr>
                <tr>
                    <th>Mitra</th>
                    <td>{{ $stok->mitra->nama }}</td>
                </tr>
                <tr>
                    <th>Masuk</th>
                    <td>{{ $stok->masuk }}</td>
                </tr>
                <tr>
                    <th>Terjual</th>
                    <td>{{ $stok->terjual }}</td>
                </tr>
                <tr>
                    <th>Return</th>
                    <td>{{ $stok->return }}</td>
                </tr>
                <tr>
                    <th>Sisa</th>
                    <td>{{ $stok->sisa }}</td>
                </tr>
                <tr>
                    <th>Dibuat</th>
                    <td>{{ $stok->created_at->format('d M Y H:i') }}</td>
                </tr>
            </table>

            <a href="{{ route('stoks.index') }}" class="btn btn-secondary mt-3">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
</div>
@endsection
