@extends('layouts.app')

@section('content')
<div class="container py-3">
    <h3>Edit Stok</h3>

    @if ($errors->any())
        <div class="alert alert-danger">
            <strong>Oops! Ada error:</strong>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body">
            <form action="{{ route('stoks.update', $stok->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="mb-3">
                    <label for="date" class="form-label">Tanggal</label>
                    <input type="date" class="form-control" id="date" name="date" value="{{ old('date', $stok->date) }}" required>
                </div>

                <div class="mb-3">
                    <label for="produk_id" class="form-label">Produk</label>
                    <select class="form-control" id="produk_id" name="produk_id" required>
                        <option value="" disabled>-- Pilih Produk --</option>
                        @foreach ($produks as $produk)
                            <option value="{{ $produk->id }}" {{ $stok->produk_id == $produk->id ? 'selected' : '' }}>
                                {{ $produk->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="mb-3">
                    <label for="mitra_id" class="form-label">Mitra</label>
                    <select class="form-control" id="mitra_id" name="mitra_id" required>
                        <option value="" disabled>-- Pilih Mitra --</option>
                        @foreach ($mitras as $mitra)
                            <option value="{{ $mitra->id }}" {{ $stok->mitra_id == $mitra->id ? 'selected' : '' }}>
                                {{ $mitra->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label for="masuk" class="form-label">Masuk</label>
                        <input type="number" min="0" class="form-control" id="masuk" name="masuk" value="{{ old('masuk', $stok->masuk) }}" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="terjual" class="form-label">Terjual</label>
                        <input type="number" min="0" class="form-control" id="terjual" name="terjual" value="{{ old('terjual', $stok->terjual) }}" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="return" class="form-label">Return</label>
                        <input type="number" min="0" class="form-control" id="return" name="return" value="{{ old('return', $stok->return) }}" required>
                    </div>
                </div>

                <div class="mb-3">
                    <label for="sisa" class="form-label">Sisa</label>
                    <input type="text" class="form-control" id="sisa" name="sisa" value="{{ old('sisa', $stok->sisa) }}" readonly>
                </div>

                <button type="submit" class="btn btn-success">
                    <i class="fas fa-save"></i> Update
                </button>
                <a href="{{ route('stoks.index') }}" class="btn btn-secondary ms-2">Batal</a>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    function hitungSisa() {
        let masuk = parseInt(document.getElementById('masuk').value) || 0;
        let terjual = parseInt(document.getElementById('terjual').value) || 0;
        let ret = parseInt(document.getElementById('return').value) || 0;
        let sisa = masuk - terjual + ret;
        document.getElementById('sisa').value = sisa >= 0 ? sisa : 0;
    }

    document.getElementById('masuk').addEventListener('input', hitungSisa);
    document.getElementById('terjual').addEventListener('input', hitungSisa);
    document.getElementById('return').addEventListener('input', hitungSisa);
    window.addEventListener('load', hitungSisa);
</script>
@endpush
