@extends('layouts.app')

@section('content')
<div class="container">
    <h3 class="mb-4">Stok Pusat</h3>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="text-end mb-3">
        <a href="{{ route('stok-pusat.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Tambah Stok Pusat
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-bordered table-striped" id="stok-pusat-table">
                <thead class="table-dark">
                    <tr>
                        <th>No</th>
                        <th>Tanggal</th>
                        <th>Produk</th>
                        <th>Masuk</th>
                        <th>Terjual</th>
                        <th>Return</th>
                        <th>Sisa</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($stoks as $stok)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ \Carbon\Carbon::parse($stok->date)->format('d-m-Y') }}</td>
                            <td>{{ $stok->produk->name ?? '-' }}</td>
                            <td>{{ $stok->masuk }}</td>
                            <td>{{ $stok->terjual }}</td>
                            <td>{{ $stok->return }}</td>
                            <td>{{ $stok->sisa }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
