@extends('layouts.app')

@section('title', 'Tambah / Update Stok Pusat')

@section('content')
<div class="container">
    <h1 class="mb-4">Tambah / Update Stok Pusat</h1>

    @if($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('stok-pusat.store') }}" method="POST">
        @csrf
    
        <!-- Produk -->
        <div class="mb-3">
            <label for="produk_id" class="form-label">Produk</label>
            <select name="produk_id" id="produk_id" class="form-control" required>
                <option value="">-- Pilih Produk --</option>
                @foreach($produks as $produk)
                    <option value="{{ $produk->id }}" {{ old('produk_id') == $produk->id ? 'selected' : '' }}>
                        {{ $produk->name }}
                    </option>
                @endforeach
            </select>
        </div> 
        <!-- Jumlah Masuk -->
        <div class="mb-3">
            <label for="masuk">Jumlah Masuk</label>
            <input type="number" name="masuk" class="form-control" value="{{ old('masuk') }}"required>
        </div>
        {{-- <div class="mb-3">
            <label for="sisa" class="form-label">Jumlah Stok</label>
            <input type="number" name="sisa" id="sisa" class="form-control" value="{{ old('sisa') }}" required min="0">
        </div> --}}
        <!-- Tanggal Masuk -->
        <div class="mb-3">
            <label for="tanggal_masuk">Tanggal Masuk</label>
            <input type="date" name="tanggal_masuk" class="form-control" value="{{ now()->toDateString() }}" required>
        </div>
    
        <button type="submit" class="btn btn-primary">Simpan</button>
    </form>
    
</div>
@endsection
