@extends('layouts.app')

@section('content')
<div class="container">
    <h3 class="mb-4">Stok Mitra</h3>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
{{-- 
    <div class="text-end mb-3">
        <a href="{{ route('stok-mitra.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Tambah Stok Mitra
        </a>
    </div> --}}

    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-bordered table-striped table-hover align-middle text-nowrap" id="stok-mitra-table">
                <thead class="table-dark">
                    <tr>
                        <th>No</th>
                        <th>Mitra</th>
                        <th>Produk</th>
                        <th>Masuk</th>
                        <th>Terjual</th>
                        <th>Return</th>
                        <th>Sisa</th>
                        <th>Tanggal</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($stoks as $stok)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $stok->mitra_nama }}</td>
                            <td>{{ $stok->produk_nama }}</td>
                            <td>{{ $stok->total_masuk }}</td>
                            <td>{{ $stok->total_terjual }}</td>
                            <td>{{ $stok->total_return }}</td>
                            <td>{{ $stok->total_sisa }}</td>
                            <td>{{ \Carbon\Carbon::parse($stok->created_at ?? now())->format('d-m-Y') }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
