@extends('layouts.app')

@section('content')
<div class="container">
    <h3 class="mb-4">Tambah Stok Mitra</h3>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('stok-mitra.store') }}" method="POST">
        @csrf
        <div class="mb-3">
            <label for="produk_id" class="form-label">Produk</label>
            <select name="produk_id" id="produk_id" class="form-control" required>
                <option value="">-- Pilih Produk --</option>
                @foreach ($produks as $produk)
                    <option value="{{ $produk->id }}">{{ $produk->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label for="mitra_id" class="form-label">Mitra</label>
            <select name="mitra_id" id="mitra_id" class="form-control" required>
                <option value="">-- Pilih Mitra --</option>
                @foreach ($mitras as $mitra)
                    <option value="{{ $mitra->id }}">{{ $mitra->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label for="masuk" class="form-label">Jumlah Masuk</label>
            <input type="number" name="masuk" id="masuk" class="form-control" required min="1">
        </div>

        <button type="submit" class="btn btn-success">Simpan</button>
        <a href="{{ route('stok-mitra.index') }}" class="btn btn-secondary">Kembali</a>
    </form>
</div>
@endsection
