@extends('layouts.app')

@section('content')
<div class="container py-4">
    <h3>Data Stok Mitra Anda</h3>
    @if($stokMitra->count())
    <div class="table-responsive">
        <table class="table table-bordered table-striped mt-3">
            <thead class="table-dark">
                <tr>
                    <th>No</th>
                    <th>Mitra</th>
                    <th>Produk</th>
                    <th>Masuk</th>
                    <th>Terjual</th>
                    <th>Return</th>
                    <th>Sisa</th>
                    <th>Tanggal</th>
                </tr>
            </thead>
            <tbody>
                @foreach($stokMitra as $stok)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $stok->mitra_nama }}</td>
                    <td>{{ $stok->produk_nama }}</td>
                    <td>{{ $stok->total_masuk }}</td>
                    <td>{{ $stok->total_terjual }}</td>
                    <td>{{ $stok->total_return }}</td>
                    <td>{{ $stok->total_sisa }}</td>
                    <td>{{ \Carbon\Carbon::parse($stok->created_at ?? now())->format('d-m-Y') }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @else
        <div class="alert alert-warning">Belum ada data stok untuk mitra Anda.</div>
    @endif
</div>
@endsection
