@extends('layouts.app')

@section('content')
    <div class="container">
        <h1>Riwayat Pengiriman Stok</h1>

        <table class="table">
            <thead>
                <tr>
                    <th>Produk</th>
                    <th>Mitra</th>
                    <th>Jumlah</th>
                    <th>Tanggal Kirim</th>
                    <th>Status</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($pengiriman as $item)
                    <tr>
                        <td>{{ $item->produk->name }}</td>
                        <td>{{ $item->mitra->name }}</td>
                        <td>{{ $item->jumlah }}</td>
                        <td>{{ $item->tanggal_kirim }}</td>
                        <td>{{ $item->status }}</td>
                        <td>
                            @if ($item->status == 'dikirim')
                                <form action="{{ route('riwayat-stok.terima', $item->id) }}" method="POST">
                                    @csrf
                                    @method('PATCH')
                                    <button type="submit" class="btn btn-success">Terima</button>
                                </form>
                            @else
                                <span class="text-success">Diterima</span>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection
