@extends('layouts.app')

@section('content')
<div class="container-fluid col-md-10 py-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h4 class="mb-0">Detail Produk</h4>
        </div>

        <div class="card-body row">
            <div class="col-md-5">
                @if($produk->image)
                    <img src="{{ asset('storage/' . $produk->image) }}" alt="Gambar Produk" class="img-fluid rounded shadow-sm">
                @else
                    <div class="text-muted fst-italic">Gambar tidak tersedia</div>
                @endif
            </div>

            <div class="col-md-7">
                <h5 class="fw-bold">{{ $produk->name }}</h5>
                <p class="text-muted">Deskripsi:</p>
                <p>{{ $produk->explanation }}</p>

                <div class="mt-4">
                    <a href="{{ route('produks.edit', $produk->id) }}" class="btn btn-sm btn-warning  mb-1">
                        <i class="fas fa-edit"></i> Edit
                    </a>

                    <form id="delete-form-{{ $produk->id }}" action="{{ route('produks.destroy', $produk->id) }}" method="POST" style="display: inline;">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-sm btn-danger mb-1" onclick="confirmDelete({{ $produk->id }})">
                            <i class="fas fa-trash"></i> Hapus
                        </button>
                    </form>
                </div>
            </div>
            <button  class="btn btn-primary  mt-4">
                <a href="{{ route('produks.index') }}" class="text-white ">← Kembali</a>
            </button>
            <button  class="btn btn-warning  mt-4">
                <a href="{{ route('stoks.index') }}" class="text-white "><i class="fas fa-edit"></i> Edit</a>
            </button>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    function confirmDelete(id) {
        Swal.fire({
            title: 'Apakah kamu yakin?',
            text: "Data yang dihapus tidak bisa dikembalikan!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Ya, hapus!',
            cancelButtonText: 'Batal'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('delete-form-' + id).submit();
            }
        })
    }
</script>
@endpush