@extends('layouts.app')

@section('content')
<div class="container-fluid">
    {{-- JUDUL --}}
    <div class="row mb-3">
        <div class="col-12">
            <h3 class="mt-3">Daftar Produk</h3>
        </div>
    </div>

    {{-- ALERT MESSAGE --}}
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    @if ($errors->any())
        <div class="alert alert-danger">
            <strong>Oops! Ada error:</strong>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- FORM SEARCH + BUTTON TAMBAH --}}
    <div class="row mb-4 align-items-end">
        <div class="col-md-6 text-md-end mb-2">
            <a href="{{ route('produks.create') }}" class="btn btn-success">
                <i class="fas fa-plus"></i> Tambah Produk
            </a>
        </div>
        <div class="col-md-6 mb-2">
            <form method="GET" action="{{ route('produks.index') }}">
                <div class="input-group">
                    <input type="text" name="search" class="form-control" placeholder="Cari produk..." value="{{ request('search') }}">
                    <button class="btn btn-outline-secondary" type="submit">Cari</button>
                </div>
            </form>
        </div>
    </div>

    {{-- PRODUK LIST --}}
    @if($produks->count())
        <div class="row">
            @foreach($produks as $produk)
                <div class="col-12 col-md-6 col-lg-4 mb-4">
                    <div class="card h-100 shadow-sm">
                        @if($produk->image)
                            <img src="{{ asset('storage/' . $produk->image) }}" class="card-img-top" style="height: 200px; object-fit: cover;" alt="{{ $produk->name }}">
                        @else
                            <div class="bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                                <span class="text-muted">Tidak ada gambar</span>
                            </div>
                        @endif
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title">{{ $produk->name }}</h5>
                            <p class="card-text text-muted">{{ Str::limit($produk->explanation, 100) }}</p>
                            <h5 class="card-title">{{ $produk->price }}</h5>
                        </div>
                        <div class="card-footer bg-white border-top-0 text-end">
                            <a href="{{ route('produks.show', $produk->id) }}" class="btn btn-sm btn-info me-1 mb-1">
                                <i class="fas fa-eye"></i> Detail
                            </a>
                            <a href="{{ route('produks.edit', $produk->id) }}" class="btn btn-sm btn-warning me-1 mb-1">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                            <form id="delete-form-{{ $produk->id }}" action="{{ route('produks.destroy', $produk->id) }}" method="POST" style="display: inline;">
                                @csrf
                                @method('DELETE')
                                <button type="button" class="btn btn-sm btn-danger mb-1" onclick="confirmDelete({{ $produk->id }})">
                                    <i class="fas fa-trash"></i> Hapus
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <div class="alert alert-info col-md-6">
            Belum ada produk yang tersedia. Klik <strong><a href="{{ route('produks.create') }}" class="text-decoration-none text-warning">Tambah Produk</a></strong> untuk mulai menambahkan.
        </div>
    @endif

    {{-- PAGINATION POJOK --}}
    <div class="d-flex justify-content-end mt-4">
        {{ $produks->withQueryString()->links() }}
    </div>
</div>
@endsection

@push('scripts')
<script>
    function confirmDelete(id) {
        Swal.fire({
            title: 'Apakah kamu yakin?',
            text: "Data yang dihapus tidak bisa dikembalikan!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Ya, hapus!',
            cancelButtonText: 'Batal'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('delete-form-' + id).submit();
            }
        })
    }
</script>
@endpush
